/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.SkuCapability;
import com.azure.resourcemanager.elasticsan.models.SkuLocationInfo;
import com.azure.resourcemanager.elasticsan.models.SkuName;
import com.azure.resourcemanager.elasticsan.models.SkuTier;
import java.io.IOException;
import java.util.List;

public final class SkuInformationInner
implements JsonSerializable<SkuInformationInner> {
    private SkuName name;
    private SkuTier tier;
    private String resourceType;
    private List<String> locations;
    private List<SkuLocationInfo> locationInfo;
    private List<SkuCapability> capabilities;
    private static final ClientLogger LOGGER = new ClientLogger(SkuInformationInner.class);

    public SkuName name() {
        return this.name;
    }

    public SkuInformationInner withName(SkuName name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public SkuInformationInner withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<SkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public List<SkuCapability> capabilities() {
        return this.capabilities;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SkuInformationInner"));
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeStringField("tier", this.tier == null ? null : this.tier.toString());
        return jsonWriter.writeEndObject();
    }

    public static SkuInformationInner fromJson(JsonReader jsonReader) throws IOException {
        return (SkuInformationInner)jsonReader.readObject(reader -> {
            SkuInformationInner deserializedSkuInformationInner = new SkuInformationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSkuInformationInner.name = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("tier".equals(fieldName)) {
                    deserializedSkuInformationInner.tier = SkuTier.fromString(reader.getString());
                    continue;
                }
                if ("resourceType".equals(fieldName)) {
                    deserializedSkuInformationInner.resourceType = reader.getString();
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedSkuInformationInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedSkuInformationInner.locationInfo = locationInfo = reader.readArray(reader1 -> SkuLocationInfo.fromJson(reader1));
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedSkuInformationInner.capabilities = capabilities = reader.readArray(reader1 -> SkuCapability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSkuInformationInner;
        });
    }
}

