/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import java.io.IOException;

public final class ElasticSanUpdateProperties
implements JsonSerializable<ElasticSanUpdateProperties> {
    private Long baseSizeTiB;
    private Long extendedCapacitySizeTiB;
    private PublicNetworkAccess publicNetworkAccess;
    private AutoScaleProperties autoScaleProperties;

    public Long baseSizeTiB() {
        return this.baseSizeTiB;
    }

    public ElasticSanUpdateProperties withBaseSizeTiB(Long baseSizeTiB) {
        this.baseSizeTiB = baseSizeTiB;
        return this;
    }

    public Long extendedCapacitySizeTiB() {
        return this.extendedCapacitySizeTiB;
    }

    public ElasticSanUpdateProperties withExtendedCapacitySizeTiB(Long extendedCapacitySizeTiB) {
        this.extendedCapacitySizeTiB = extendedCapacitySizeTiB;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ElasticSanUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public AutoScaleProperties autoScaleProperties() {
        return this.autoScaleProperties;
    }

    public ElasticSanUpdateProperties withAutoScaleProperties(AutoScaleProperties autoScaleProperties) {
        this.autoScaleProperties = autoScaleProperties;
        return this;
    }

    public void validate() {
        if (this.autoScaleProperties() != null) {
            this.autoScaleProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("baseSizeTiB", (Number)this.baseSizeTiB);
        jsonWriter.writeNumberField("extendedCapacitySizeTiB", (Number)this.extendedCapacitySizeTiB);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("autoScaleProperties", (JsonSerializable)this.autoScaleProperties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticSanUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSanUpdateProperties)jsonReader.readObject(reader -> {
            ElasticSanUpdateProperties deserializedElasticSanUpdateProperties = new ElasticSanUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("baseSizeTiB".equals(fieldName)) {
                    deserializedElasticSanUpdateProperties.baseSizeTiB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("extendedCapacitySizeTiB".equals(fieldName)) {
                    deserializedElasticSanUpdateProperties.extendedCapacitySizeTiB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedElasticSanUpdateProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("autoScaleProperties".equals(fieldName)) {
                    deserializedElasticSanUpdateProperties.autoScaleProperties = AutoScaleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSanUpdateProperties;
        });
    }
}

