/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import com.azure.resourcemanager.elasticsan.models.Sku;
import java.io.IOException;
import java.util.List;

public final class ElasticSanProperties
implements JsonSerializable<ElasticSanProperties> {
    private Sku sku;
    private List<String> availabilityZones;
    private ProvisioningStates provisioningState;
    private long baseSizeTiB;
    private long extendedCapacitySizeTiB;
    private Long totalVolumeSizeGiB;
    private Long volumeGroupCount;
    private Long totalIops;
    private Long totalMBps;
    private Long totalSizeTiB;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;
    private AutoScaleProperties autoScaleProperties;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticSanProperties.class);

    public Sku sku() {
        return this.sku;
    }

    public ElasticSanProperties withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public ElasticSanProperties withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.provisioningState;
    }

    public long baseSizeTiB() {
        return this.baseSizeTiB;
    }

    public ElasticSanProperties withBaseSizeTiB(long baseSizeTiB) {
        this.baseSizeTiB = baseSizeTiB;
        return this;
    }

    public long extendedCapacitySizeTiB() {
        return this.extendedCapacitySizeTiB;
    }

    public ElasticSanProperties withExtendedCapacitySizeTiB(long extendedCapacitySizeTiB) {
        this.extendedCapacitySizeTiB = extendedCapacitySizeTiB;
        return this;
    }

    public Long totalVolumeSizeGiB() {
        return this.totalVolumeSizeGiB;
    }

    public Long volumeGroupCount() {
        return this.volumeGroupCount;
    }

    public Long totalIops() {
        return this.totalIops;
    }

    public Long totalMBps() {
        return this.totalMBps;
    }

    public Long totalSizeTiB() {
        return this.totalSizeTiB;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ElasticSanProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public AutoScaleProperties autoScaleProperties() {
        return this.autoScaleProperties;
    }

    public ElasticSanProperties withAutoScaleProperties(AutoScaleProperties autoScaleProperties) {
        this.autoScaleProperties = autoScaleProperties;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ElasticSanProperties"));
        }
        this.sku().validate();
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.autoScaleProperties() != null) {
            this.autoScaleProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeLongField("baseSizeTiB", this.baseSizeTiB);
        jsonWriter.writeLongField("extendedCapacitySizeTiB", this.extendedCapacitySizeTiB);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("autoScaleProperties", (JsonSerializable)this.autoScaleProperties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticSanProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSanProperties)jsonReader.readObject(reader -> {
            ElasticSanProperties deserializedElasticSanProperties = new ElasticSanProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedElasticSanProperties.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("baseSizeTiB".equals(fieldName)) {
                    deserializedElasticSanProperties.baseSizeTiB = reader.getLong();
                    continue;
                }
                if ("extendedCapacitySizeTiB".equals(fieldName)) {
                    deserializedElasticSanProperties.extendedCapacitySizeTiB = reader.getLong();
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedElasticSanProperties.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedElasticSanProperties.provisioningState = ProvisioningStates.fromString(reader.getString());
                    continue;
                }
                if ("totalVolumeSizeGiB".equals(fieldName)) {
                    deserializedElasticSanProperties.totalVolumeSizeGiB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("volumeGroupCount".equals(fieldName)) {
                    deserializedElasticSanProperties.volumeGroupCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalIops".equals(fieldName)) {
                    deserializedElasticSanProperties.totalIops = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalMBps".equals(fieldName)) {
                    deserializedElasticSanProperties.totalMBps = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalSizeTiB".equals(fieldName)) {
                    deserializedElasticSanProperties.totalSizeTiB = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedElasticSanProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedElasticSanProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("autoScaleProperties".equals(fieldName)) {
                    deserializedElasticSanProperties.autoScaleProperties = AutoScaleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSanProperties;
        });
    }
}

