/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elasticsan.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elasticsan.fluent.models.ElasticSanProperties;
import com.azure.resourcemanager.elasticsan.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.elasticsan.models.AutoScaleProperties;
import com.azure.resourcemanager.elasticsan.models.ProvisioningStates;
import com.azure.resourcemanager.elasticsan.models.PublicNetworkAccess;
import com.azure.resourcemanager.elasticsan.models.Sku;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ElasticSanInner
extends Resource {
    private ElasticSanProperties innerProperties = new ElasticSanProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticSanInner.class);

    private ElasticSanProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticSanInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticSanInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Sku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ElasticSanInner withSku(Sku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public List<String> availabilityZones() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZones();
    }

    public ElasticSanInner withAvailabilityZones(List<String> availabilityZones) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withAvailabilityZones(availabilityZones);
        return this;
    }

    public ProvisioningStates provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public long baseSizeTiB() {
        return this.innerProperties() == null ? 0L : this.innerProperties().baseSizeTiB();
    }

    public ElasticSanInner withBaseSizeTiB(long baseSizeTiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withBaseSizeTiB(baseSizeTiB);
        return this;
    }

    public long extendedCapacitySizeTiB() {
        return this.innerProperties() == null ? 0L : this.innerProperties().extendedCapacitySizeTiB();
    }

    public ElasticSanInner withExtendedCapacitySizeTiB(long extendedCapacitySizeTiB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withExtendedCapacitySizeTiB(extendedCapacitySizeTiB);
        return this;
    }

    public Long totalVolumeSizeGiB() {
        return this.innerProperties() == null ? null : this.innerProperties().totalVolumeSizeGiB();
    }

    public Long volumeGroupCount() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeGroupCount();
    }

    public Long totalIops() {
        return this.innerProperties() == null ? null : this.innerProperties().totalIops();
    }

    public Long totalMBps() {
        return this.innerProperties() == null ? null : this.innerProperties().totalMBps();
    }

    public Long totalSizeTiB() {
        return this.innerProperties() == null ? null : this.innerProperties().totalSizeTiB();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ElasticSanInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public AutoScaleProperties autoScaleProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleProperties();
    }

    public ElasticSanInner withAutoScaleProperties(AutoScaleProperties autoScaleProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticSanProperties();
        }
        this.innerProperties().withAutoScaleProperties(autoScaleProperties);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ElasticSanInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ElasticSanInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticSanInner)((Object)jsonReader.readObject(reader -> {
            ElasticSanInner deserializedElasticSanInner = new ElasticSanInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticSanInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticSanInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticSanInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticSanInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticSanInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticSanInner.innerProperties = ElasticSanProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticSanInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticSanInner;
        }));
    }
}

