/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.CompanyInfo;
import java.io.IOException;

public final class UserInfo
implements JsonSerializable<UserInfo> {
    private String firstName;
    private String lastName;
    private String companyName;
    private String emailAddress;
    private CompanyInfo companyInfo;

    public String firstName() {
        return this.firstName;
    }

    public UserInfo withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String lastName() {
        return this.lastName;
    }

    public UserInfo withLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String companyName() {
        return this.companyName;
    }

    public UserInfo withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public UserInfo withEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    public CompanyInfo companyInfo() {
        return this.companyInfo;
    }

    public UserInfo withCompanyInfo(CompanyInfo companyInfo) {
        this.companyInfo = companyInfo;
        return this;
    }

    public void validate() {
        if (this.companyInfo() != null) {
            this.companyInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("firstName", this.firstName);
        jsonWriter.writeStringField("lastName", this.lastName);
        jsonWriter.writeStringField("companyName", this.companyName);
        jsonWriter.writeStringField("emailAddress", this.emailAddress);
        jsonWriter.writeJsonField("companyInfo", (JsonSerializable)this.companyInfo);
        return jsonWriter.writeEndObject();
    }

    public static UserInfo fromJson(JsonReader jsonReader) throws IOException {
        return (UserInfo)jsonReader.readObject(reader -> {
            UserInfo deserializedUserInfo = new UserInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("firstName".equals(fieldName)) {
                    deserializedUserInfo.firstName = reader.getString();
                    continue;
                }
                if ("lastName".equals(fieldName)) {
                    deserializedUserInfo.lastName = reader.getString();
                    continue;
                }
                if ("companyName".equals(fieldName)) {
                    deserializedUserInfo.companyName = reader.getString();
                    continue;
                }
                if ("emailAddress".equals(fieldName)) {
                    deserializedUserInfo.emailAddress = reader.getString();
                    continue;
                }
                if ("companyInfo".equals(fieldName)) {
                    deserializedUserInfo.companyInfo = CompanyInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserInfo;
        });
    }
}

