/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.MonitoredSubscription;
import com.azure.resourcemanager.elastic.models.Operation;
import com.azure.resourcemanager.elastic.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class SubscriptionList
implements JsonSerializable<SubscriptionList> {
    private Operation operation;
    private List<MonitoredSubscription> monitoredSubscriptionList;
    private ProvisioningState provisioningState;

    public Operation operation() {
        return this.operation;
    }

    public SubscriptionList withOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public List<MonitoredSubscription> monitoredSubscriptionList() {
        return this.monitoredSubscriptionList;
    }

    public SubscriptionList withMonitoredSubscriptionList(List<MonitoredSubscription> monitoredSubscriptionList) {
        this.monitoredSubscriptionList = monitoredSubscriptionList;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.monitoredSubscriptionList() != null) {
            this.monitoredSubscriptionList().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operation", this.operation == null ? null : this.operation.toString());
        jsonWriter.writeArrayField("monitoredSubscriptionList", this.monitoredSubscriptionList, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionList fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionList)jsonReader.readObject(reader -> {
            SubscriptionList deserializedSubscriptionList = new SubscriptionList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operation".equals(fieldName)) {
                    deserializedSubscriptionList.operation = Operation.fromString(reader.getString());
                    continue;
                }
                if ("monitoredSubscriptionList".equals(fieldName)) {
                    List monitoredSubscriptionList;
                    deserializedSubscriptionList.monitoredSubscriptionList = monitoredSubscriptionList = reader.readArray(reader1 -> MonitoredSubscription.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSubscriptionList.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionList;
        });
    }
}

