/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.ConfigurationType;
import com.azure.resourcemanager.elastic.models.ProjectType;
import java.io.IOException;

public final class ProjectDetails
implements JsonSerializable<ProjectDetails> {
    private ProjectType projectType;
    private ConfigurationType configurationType;

    public ProjectType projectType() {
        return this.projectType;
    }

    public ProjectDetails withProjectType(ProjectType projectType) {
        this.projectType = projectType;
        return this;
    }

    public ConfigurationType configurationType() {
        return this.configurationType;
    }

    public ProjectDetails withConfigurationType(ConfigurationType configurationType) {
        this.configurationType = configurationType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("projectType", this.projectType == null ? null : this.projectType.toString());
        jsonWriter.writeStringField("configurationType", this.configurationType == null ? null : this.configurationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ProjectDetails fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectDetails)jsonReader.readObject(reader -> {
            ProjectDetails deserializedProjectDetails = new ProjectDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("projectType".equals(fieldName)) {
                    deserializedProjectDetails.projectType = ProjectType.fromString(reader.getString());
                    continue;
                }
                if ("configurationType".equals(fieldName)) {
                    deserializedProjectDetails.configurationType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectDetails;
        });
    }
}

