/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class OpenAIIntegrationProperties
implements JsonSerializable<OpenAIIntegrationProperties> {
    private String openAIResourceId;
    private String openAIResourceEndpoint;
    private String openAIConnectorId;
    private String key;
    private OffsetDateTime lastRefreshAt;

    public String openAIResourceId() {
        return this.openAIResourceId;
    }

    public OpenAIIntegrationProperties withOpenAIResourceId(String openAIResourceId) {
        this.openAIResourceId = openAIResourceId;
        return this;
    }

    public String openAIResourceEndpoint() {
        return this.openAIResourceEndpoint;
    }

    public OpenAIIntegrationProperties withOpenAIResourceEndpoint(String openAIResourceEndpoint) {
        this.openAIResourceEndpoint = openAIResourceEndpoint;
        return this;
    }

    public String openAIConnectorId() {
        return this.openAIConnectorId;
    }

    public OpenAIIntegrationProperties withOpenAIConnectorId(String openAIConnectorId) {
        this.openAIConnectorId = openAIConnectorId;
        return this;
    }

    public String key() {
        return this.key;
    }

    public OpenAIIntegrationProperties withKey(String key) {
        this.key = key;
        return this;
    }

    public OffsetDateTime lastRefreshAt() {
        return this.lastRefreshAt;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("openAIResourceId", this.openAIResourceId);
        jsonWriter.writeStringField("openAIResourceEndpoint", this.openAIResourceEndpoint);
        jsonWriter.writeStringField("openAIConnectorId", this.openAIConnectorId);
        jsonWriter.writeStringField("key", this.key);
        return jsonWriter.writeEndObject();
    }

    public static OpenAIIntegrationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (OpenAIIntegrationProperties)jsonReader.readObject(reader -> {
            OpenAIIntegrationProperties deserializedOpenAIIntegrationProperties = new OpenAIIntegrationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("openAIResourceId".equals(fieldName)) {
                    deserializedOpenAIIntegrationProperties.openAIResourceId = reader.getString();
                    continue;
                }
                if ("openAIResourceEndpoint".equals(fieldName)) {
                    deserializedOpenAIIntegrationProperties.openAIResourceEndpoint = reader.getString();
                    continue;
                }
                if ("openAIConnectorId".equals(fieldName)) {
                    deserializedOpenAIIntegrationProperties.openAIConnectorId = reader.getString();
                    continue;
                }
                if ("key".equals(fieldName)) {
                    deserializedOpenAIIntegrationProperties.key = reader.getString();
                    continue;
                }
                if ("lastRefreshAt".equals(fieldName)) {
                    deserializedOpenAIIntegrationProperties.lastRefreshAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenAIIntegrationProperties;
        });
    }
}

