/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.MonitoringTagRulesProperties;
import com.azure.resourcemanager.elastic.models.Status;
import java.io.IOException;

public final class MonitoredSubscription
implements JsonSerializable<MonitoredSubscription> {
    private String subscriptionId;
    private Status status;
    private String error;
    private MonitoringTagRulesProperties tagRules;

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public MonitoredSubscription withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public MonitoredSubscription withStatus(Status status) {
        this.status = status;
        return this;
    }

    public String error() {
        return this.error;
    }

    public MonitoredSubscription withError(String error) {
        this.error = error;
        return this;
    }

    public MonitoringTagRulesProperties tagRules() {
        return this.tagRules;
    }

    public MonitoredSubscription withTagRules(MonitoringTagRulesProperties tagRules) {
        this.tagRules = tagRules;
        return this;
    }

    public void validate() {
        if (this.tagRules() != null) {
            this.tagRules().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeJsonField("tagRules", (JsonSerializable)this.tagRules);
        return jsonWriter.writeEndObject();
    }

    public static MonitoredSubscription fromJson(JsonReader jsonReader) throws IOException {
        return (MonitoredSubscription)jsonReader.readObject(reader -> {
            MonitoredSubscription deserializedMonitoredSubscription = new MonitoredSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionId".equals(fieldName)) {
                    deserializedMonitoredSubscription.subscriptionId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMonitoredSubscription.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMonitoredSubscription.error = reader.getString();
                    continue;
                }
                if ("tagRules".equals(fieldName)) {
                    deserializedMonitoredSubscription.tagRules = MonitoringTagRulesProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitoredSubscription;
        });
    }
}

