/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.fluent.models.MonitoredResourceInner;
import java.io.IOException;
import java.util.List;

public final class MonitoredResourceListResponse
implements JsonSerializable<MonitoredResourceListResponse> {
    private List<MonitoredResourceInner> value;
    private String nextLink;

    public List<MonitoredResourceInner> value() {
        return this.value;
    }

    public MonitoredResourceListResponse withValue(List<MonitoredResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public MonitoredResourceListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static MonitoredResourceListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (MonitoredResourceListResponse)jsonReader.readObject(reader -> {
            MonitoredResourceListResponse deserializedMonitoredResourceListResponse = new MonitoredResourceListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedMonitoredResourceListResponse.value = value = reader.readArray(reader1 -> MonitoredResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedMonitoredResourceListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitoredResourceListResponse;
        });
    }
}

