/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.ElasticProperties;
import com.azure.resourcemanager.elastic.models.HostingType;
import com.azure.resourcemanager.elastic.models.LiftrResourceCategories;
import com.azure.resourcemanager.elastic.models.MonitoringStatus;
import com.azure.resourcemanager.elastic.models.PlanDetails;
import com.azure.resourcemanager.elastic.models.ProjectDetails;
import com.azure.resourcemanager.elastic.models.ProvisioningState;
import com.azure.resourcemanager.elastic.models.UserInfo;
import java.io.IOException;

public final class MonitorProperties
implements JsonSerializable<MonitorProperties> {
    private ProvisioningState provisioningState;
    private MonitoringStatus monitoringStatus;
    private ElasticProperties elasticProperties;
    private UserInfo userInfo;
    private PlanDetails planDetails;
    private String version;
    private String subscriptionState;
    private String saaSAzureSubscriptionStatus;
    private String sourceCampaignName;
    private String sourceCampaignId;
    private LiftrResourceCategories liftrResourceCategory;
    private Integer liftrResourcePreference;
    private Boolean generateApiKey;
    private HostingType hostingType;
    private ProjectDetails projectDetails;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public MonitoringStatus monitoringStatus() {
        return this.monitoringStatus;
    }

    public MonitorProperties withMonitoringStatus(MonitoringStatus monitoringStatus) {
        this.monitoringStatus = monitoringStatus;
        return this;
    }

    public ElasticProperties elasticProperties() {
        return this.elasticProperties;
    }

    public MonitorProperties withElasticProperties(ElasticProperties elasticProperties) {
        this.elasticProperties = elasticProperties;
        return this;
    }

    public UserInfo userInfo() {
        return this.userInfo;
    }

    public MonitorProperties withUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    public PlanDetails planDetails() {
        return this.planDetails;
    }

    public MonitorProperties withPlanDetails(PlanDetails planDetails) {
        this.planDetails = planDetails;
        return this;
    }

    public String version() {
        return this.version;
    }

    public MonitorProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public String subscriptionState() {
        return this.subscriptionState;
    }

    public MonitorProperties withSubscriptionState(String subscriptionState) {
        this.subscriptionState = subscriptionState;
        return this;
    }

    public String saaSAzureSubscriptionStatus() {
        return this.saaSAzureSubscriptionStatus;
    }

    public MonitorProperties withSaaSAzureSubscriptionStatus(String saaSAzureSubscriptionStatus) {
        this.saaSAzureSubscriptionStatus = saaSAzureSubscriptionStatus;
        return this;
    }

    public String sourceCampaignName() {
        return this.sourceCampaignName;
    }

    public MonitorProperties withSourceCampaignName(String sourceCampaignName) {
        this.sourceCampaignName = sourceCampaignName;
        return this;
    }

    public String sourceCampaignId() {
        return this.sourceCampaignId;
    }

    public MonitorProperties withSourceCampaignId(String sourceCampaignId) {
        this.sourceCampaignId = sourceCampaignId;
        return this;
    }

    public LiftrResourceCategories liftrResourceCategory() {
        return this.liftrResourceCategory;
    }

    public Integer liftrResourcePreference() {
        return this.liftrResourcePreference;
    }

    public Boolean generateApiKey() {
        return this.generateApiKey;
    }

    public MonitorProperties withGenerateApiKey(Boolean generateApiKey) {
        this.generateApiKey = generateApiKey;
        return this;
    }

    public HostingType hostingType() {
        return this.hostingType;
    }

    public MonitorProperties withHostingType(HostingType hostingType) {
        this.hostingType = hostingType;
        return this;
    }

    public ProjectDetails projectDetails() {
        return this.projectDetails;
    }

    public MonitorProperties withProjectDetails(ProjectDetails projectDetails) {
        this.projectDetails = projectDetails;
        return this;
    }

    public void validate() {
        if (this.elasticProperties() != null) {
            this.elasticProperties().validate();
        }
        if (this.userInfo() != null) {
            this.userInfo().validate();
        }
        if (this.planDetails() != null) {
            this.planDetails().validate();
        }
        if (this.projectDetails() != null) {
            this.projectDetails().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("monitoringStatus", this.monitoringStatus == null ? null : this.monitoringStatus.toString());
        jsonWriter.writeJsonField("elasticProperties", (JsonSerializable)this.elasticProperties);
        jsonWriter.writeJsonField("userInfo", (JsonSerializable)this.userInfo);
        jsonWriter.writeJsonField("planDetails", (JsonSerializable)this.planDetails);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeStringField("subscriptionState", this.subscriptionState);
        jsonWriter.writeStringField("saaSAzureSubscriptionStatus", this.saaSAzureSubscriptionStatus);
        jsonWriter.writeStringField("sourceCampaignName", this.sourceCampaignName);
        jsonWriter.writeStringField("sourceCampaignId", this.sourceCampaignId);
        jsonWriter.writeBooleanField("generateApiKey", this.generateApiKey);
        jsonWriter.writeStringField("hostingType", this.hostingType == null ? null : this.hostingType.toString());
        jsonWriter.writeJsonField("projectDetails", (JsonSerializable)this.projectDetails);
        return jsonWriter.writeEndObject();
    }

    public static MonitorProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MonitorProperties)jsonReader.readObject(reader -> {
            MonitorProperties deserializedMonitorProperties = new MonitorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedMonitorProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("monitoringStatus".equals(fieldName)) {
                    deserializedMonitorProperties.monitoringStatus = MonitoringStatus.fromString(reader.getString());
                    continue;
                }
                if ("elasticProperties".equals(fieldName)) {
                    deserializedMonitorProperties.elasticProperties = ElasticProperties.fromJson(reader);
                    continue;
                }
                if ("userInfo".equals(fieldName)) {
                    deserializedMonitorProperties.userInfo = UserInfo.fromJson(reader);
                    continue;
                }
                if ("planDetails".equals(fieldName)) {
                    deserializedMonitorProperties.planDetails = PlanDetails.fromJson(reader);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMonitorProperties.version = reader.getString();
                    continue;
                }
                if ("subscriptionState".equals(fieldName)) {
                    deserializedMonitorProperties.subscriptionState = reader.getString();
                    continue;
                }
                if ("saaSAzureSubscriptionStatus".equals(fieldName)) {
                    deserializedMonitorProperties.saaSAzureSubscriptionStatus = reader.getString();
                    continue;
                }
                if ("sourceCampaignName".equals(fieldName)) {
                    deserializedMonitorProperties.sourceCampaignName = reader.getString();
                    continue;
                }
                if ("sourceCampaignId".equals(fieldName)) {
                    deserializedMonitorProperties.sourceCampaignId = reader.getString();
                    continue;
                }
                if ("liftrResourceCategory".equals(fieldName)) {
                    deserializedMonitorProperties.liftrResourceCategory = LiftrResourceCategories.fromString(reader.getString());
                    continue;
                }
                if ("liftrResourcePreference".equals(fieldName)) {
                    deserializedMonitorProperties.liftrResourcePreference = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("generateApiKey".equals(fieldName)) {
                    deserializedMonitorProperties.generateApiKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hostingType".equals(fieldName)) {
                    deserializedMonitorProperties.hostingType = HostingType.fromString(reader.getString());
                    continue;
                }
                if ("projectDetails".equals(fieldName)) {
                    deserializedMonitorProperties.projectDetails = ProjectDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitorProperties;
        });
    }
}

