/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.FilteringTag;
import java.io.IOException;
import java.util.List;

public final class LogRules
implements JsonSerializable<LogRules> {
    private Boolean sendAadLogs;
    private Boolean sendSubscriptionLogs;
    private Boolean sendActivityLogs;
    private List<FilteringTag> filteringTags;

    public Boolean sendAadLogs() {
        return this.sendAadLogs;
    }

    public LogRules withSendAadLogs(Boolean sendAadLogs) {
        this.sendAadLogs = sendAadLogs;
        return this;
    }

    public Boolean sendSubscriptionLogs() {
        return this.sendSubscriptionLogs;
    }

    public LogRules withSendSubscriptionLogs(Boolean sendSubscriptionLogs) {
        this.sendSubscriptionLogs = sendSubscriptionLogs;
        return this;
    }

    public Boolean sendActivityLogs() {
        return this.sendActivityLogs;
    }

    public LogRules withSendActivityLogs(Boolean sendActivityLogs) {
        this.sendActivityLogs = sendActivityLogs;
        return this;
    }

    public List<FilteringTag> filteringTags() {
        return this.filteringTags;
    }

    public LogRules withFilteringTags(List<FilteringTag> filteringTags) {
        this.filteringTags = filteringTags;
        return this;
    }

    public void validate() {
        if (this.filteringTags() != null) {
            this.filteringTags().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("sendAadLogs", this.sendAadLogs);
        jsonWriter.writeBooleanField("sendSubscriptionLogs", this.sendSubscriptionLogs);
        jsonWriter.writeBooleanField("sendActivityLogs", this.sendActivityLogs);
        jsonWriter.writeArrayField("filteringTags", this.filteringTags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LogRules fromJson(JsonReader jsonReader) throws IOException {
        return (LogRules)jsonReader.readObject(reader -> {
            LogRules deserializedLogRules = new LogRules();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sendAadLogs".equals(fieldName)) {
                    deserializedLogRules.sendAadLogs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sendSubscriptionLogs".equals(fieldName)) {
                    deserializedLogRules.sendSubscriptionLogs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("sendActivityLogs".equals(fieldName)) {
                    deserializedLogRules.sendActivityLogs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("filteringTags".equals(fieldName)) {
                    List filteringTags;
                    deserializedLogRules.filteringTags = filteringTags = reader.readArray(reader1 -> FilteringTag.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLogRules;
        });
    }
}

