/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.ManagedIdentityTypes;
import java.io.IOException;

public final class IdentityProperties
implements JsonSerializable<IdentityProperties> {
    private String principalId;
    private String tenantId;
    private ManagedIdentityTypes type;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ManagedIdentityTypes type() {
        return this.type;
    }

    public IdentityProperties withType(ManagedIdentityTypes type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static IdentityProperties fromJson(JsonReader jsonReader) throws IOException {
        return (IdentityProperties)jsonReader.readObject(reader -> {
            IdentityProperties deserializedIdentityProperties = new IdentityProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedIdentityProperties.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedIdentityProperties.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIdentityProperties.type = ManagedIdentityTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIdentityProperties;
        });
    }
}

