/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.TagAction;
import java.io.IOException;

public final class FilteringTag
implements JsonSerializable<FilteringTag> {
    private String name;
    private String value;
    private TagAction action;

    public String name() {
        return this.name;
    }

    public FilteringTag withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public FilteringTag withValue(String value) {
        this.value = value;
        return this;
    }

    public TagAction action() {
        return this.action;
    }

    public FilteringTag withAction(TagAction action) {
        this.action = action;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static FilteringTag fromJson(JsonReader jsonReader) throws IOException {
        return (FilteringTag)jsonReader.readObject(reader -> {
            FilteringTag deserializedFilteringTag = new FilteringTag();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedFilteringTag.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedFilteringTag.value = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedFilteringTag.action = TagAction.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFilteringTag;
        });
    }
}

