/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ExternalUserInfo
implements JsonSerializable<ExternalUserInfo> {
    private String username;
    private String fullName;
    private String password;
    private String emailId;
    private List<String> roles;

    public String username() {
        return this.username;
    }

    public ExternalUserInfo withUsername(String username) {
        this.username = username;
        return this;
    }

    public String fullName() {
        return this.fullName;
    }

    public ExternalUserInfo withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ExternalUserInfo withPassword(String password) {
        this.password = password;
        return this;
    }

    public String emailId() {
        return this.emailId;
    }

    public ExternalUserInfo withEmailId(String emailId) {
        this.emailId = emailId;
        return this;
    }

    public List<String> roles() {
        return this.roles;
    }

    public ExternalUserInfo withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("fullName", this.fullName);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("emailId", this.emailId);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ExternalUserInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ExternalUserInfo)jsonReader.readObject(reader -> {
            ExternalUserInfo deserializedExternalUserInfo = new ExternalUserInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedExternalUserInfo.username = reader.getString();
                    continue;
                }
                if ("fullName".equals(fieldName)) {
                    deserializedExternalUserInfo.fullName = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedExternalUserInfo.password = reader.getString();
                    continue;
                }
                if ("emailId".equals(fieldName)) {
                    deserializedExternalUserInfo.emailId = reader.getString();
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedExternalUserInfo.roles = roles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExternalUserInfo;
        });
    }
}

