/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.ElasticTrafficFilterRule;
import com.azure.resourcemanager.elastic.models.Type;
import java.io.IOException;
import java.util.List;

public final class ElasticTrafficFilter
implements JsonSerializable<ElasticTrafficFilter> {
    private String id;
    private String name;
    private String description;
    private String region;
    private Type type;
    private Boolean includeByDefault;
    private List<ElasticTrafficFilterRule> rules;

    public String id() {
        return this.id;
    }

    public ElasticTrafficFilter withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ElasticTrafficFilter withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ElasticTrafficFilter withDescription(String description) {
        this.description = description;
        return this;
    }

    public String region() {
        return this.region;
    }

    public ElasticTrafficFilter withRegion(String region) {
        this.region = region;
        return this;
    }

    public Type type() {
        return this.type;
    }

    public ElasticTrafficFilter withType(Type type) {
        this.type = type;
        return this;
    }

    public Boolean includeByDefault() {
        return this.includeByDefault;
    }

    public ElasticTrafficFilter withIncludeByDefault(Boolean includeByDefault) {
        this.includeByDefault = includeByDefault;
        return this;
    }

    public List<ElasticTrafficFilterRule> rules() {
        return this.rules;
    }

    public ElasticTrafficFilter withRules(List<ElasticTrafficFilterRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeBooleanField("includeByDefault", this.includeByDefault);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticTrafficFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticTrafficFilter)jsonReader.readObject(reader -> {
            ElasticTrafficFilter deserializedElasticTrafficFilter = new ElasticTrafficFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticTrafficFilter.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticTrafficFilter.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedElasticTrafficFilter.description = reader.getString();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedElasticTrafficFilter.region = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticTrafficFilter.type = Type.fromString(reader.getString());
                    continue;
                }
                if ("includeByDefault".equals(fieldName)) {
                    deserializedElasticTrafficFilter.includeByDefault = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedElasticTrafficFilter.rules = rules = reader.readArray(reader1 -> ElasticTrafficFilterRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticTrafficFilter;
        });
    }
}

