/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.ElasticCloudDeployment;
import com.azure.resourcemanager.elastic.models.ElasticCloudUser;
import java.io.IOException;

public final class ElasticProperties
implements JsonSerializable<ElasticProperties> {
    private ElasticCloudUser elasticCloudUser;
    private ElasticCloudDeployment elasticCloudDeployment;

    public ElasticCloudUser elasticCloudUser() {
        return this.elasticCloudUser;
    }

    public ElasticProperties withElasticCloudUser(ElasticCloudUser elasticCloudUser) {
        this.elasticCloudUser = elasticCloudUser;
        return this;
    }

    public ElasticCloudDeployment elasticCloudDeployment() {
        return this.elasticCloudDeployment;
    }

    public ElasticProperties withElasticCloudDeployment(ElasticCloudDeployment elasticCloudDeployment) {
        this.elasticCloudDeployment = elasticCloudDeployment;
        return this;
    }

    public void validate() {
        if (this.elasticCloudUser() != null) {
            this.elasticCloudUser().validate();
        }
        if (this.elasticCloudDeployment() != null) {
            this.elasticCloudDeployment().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("elasticCloudUser", (JsonSerializable)this.elasticCloudUser);
        jsonWriter.writeJsonField("elasticCloudDeployment", (JsonSerializable)this.elasticCloudDeployment);
        return jsonWriter.writeEndObject();
    }

    public static ElasticProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticProperties)jsonReader.readObject(reader -> {
            ElasticProperties deserializedElasticProperties = new ElasticProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("elasticCloudUser".equals(fieldName)) {
                    deserializedElasticProperties.elasticCloudUser = ElasticCloudUser.fromJson(reader);
                    continue;
                }
                if ("elasticCloudDeployment".equals(fieldName)) {
                    deserializedElasticProperties.elasticCloudDeployment = ElasticCloudDeployment.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticProperties;
        });
    }
}

