/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elastic.fluent.models.ElasticMonitorResourceInner;
import com.azure.resourcemanager.elastic.models.IdentityProperties;
import com.azure.resourcemanager.elastic.models.MonitorProperties;
import com.azure.resourcemanager.elastic.models.ResourceSku;
import java.util.Map;

public interface ElasticMonitorResource {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String kind();

    public ResourceSku sku();

    public MonitorProperties properties();

    public IdentityProperties identity();

    public SystemData systemData();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ElasticMonitorResourceInner innerModel();

    public Update update();

    public ElasticMonitorResource refresh();

    public ElasticMonitorResource refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public ElasticMonitorResource apply();

        public ElasticMonitorResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIdentity {
            public WithCreate withIdentity(IdentityProperties var1);
        }

        public static interface WithProperties {
            public WithCreate withProperties(MonitorProperties var1);
        }

        public static interface WithSku {
            public WithCreate withSku(ResourceSku var1);
        }

        public static interface WithKind {
            public WithCreate withKind(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithKind,
        WithSku,
        WithProperties,
        WithIdentity {
            public ElasticMonitorResource create();

            public ElasticMonitorResource create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

