/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.VMIngestionsClient;
import com.azure.resourcemanager.elastic.fluent.models.VMIngestionDetailsResponseInner;
import com.azure.resourcemanager.elastic.implementation.VMIngestionDetailsResponseImpl;
import com.azure.resourcemanager.elastic.models.VMIngestionDetailsResponse;
import com.azure.resourcemanager.elastic.models.VMIngestions;

public final class VMIngestionsImpl
implements VMIngestions {
    private static final ClientLogger LOGGER = new ClientLogger(VMIngestionsImpl.class);
    private final VMIngestionsClient innerClient;
    private final ElasticManager serviceManager;

    public VMIngestionsImpl(VMIngestionsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<VMIngestionDetailsResponse> detailsWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<VMIngestionDetailsResponseInner> inner = this.serviceClient().detailsWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new VMIngestionDetailsResponseImpl((VMIngestionDetailsResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public VMIngestionDetailsResponse details(String resourceGroupName, String monitorName) {
        VMIngestionDetailsResponseInner inner = this.serviceClient().details(resourceGroupName, monitorName);
        if (inner != null) {
            return new VMIngestionDetailsResponseImpl(inner, this.manager());
        }
        return null;
    }

    private VMIngestionsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

