/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.VMHostsClient;
import com.azure.resourcemanager.elastic.fluent.models.VMResourcesInner;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.implementation.VMResourcesImpl;
import com.azure.resourcemanager.elastic.models.VMHosts;
import com.azure.resourcemanager.elastic.models.VMResources;

public final class VMHostsImpl
implements VMHosts {
    private static final ClientLogger LOGGER = new ClientLogger(VMHostsImpl.class);
    private final VMHostsClient innerClient;
    private final ElasticManager serviceManager;

    public VMHostsImpl(VMHostsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<VMResources> list(String resourceGroupName, String monitorName) {
        PagedIterable<VMResourcesInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VMResourcesImpl((VMResourcesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<VMResources> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<VMResourcesInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new VMResourcesImpl((VMResourcesInner)inner1, this.manager()));
    }

    private VMHostsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

