/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.TagRulesClient;
import com.azure.resourcemanager.elastic.fluent.models.MonitoringTagRulesInner;
import com.azure.resourcemanager.elastic.implementation.MonitoringTagRulesImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.MonitoringTagRules;
import com.azure.resourcemanager.elastic.models.TagRules;

public final class TagRulesImpl
implements TagRules {
    private static final ClientLogger LOGGER = new ClientLogger(TagRulesImpl.class);
    private final TagRulesClient innerClient;
    private final ElasticManager serviceManager;

    public TagRulesImpl(TagRulesClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<MonitoringTagRules> list(String resourceGroupName, String monitorName) {
        PagedIterable<MonitoringTagRulesInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoringTagRulesImpl((MonitoringTagRulesInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MonitoringTagRules> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<MonitoringTagRulesInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoringTagRulesImpl((MonitoringTagRulesInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<MonitoringTagRules> getWithResponse(String resourceGroupName, String monitorName, String ruleSetName, Context context) {
        Response<MonitoringTagRulesInner> inner = this.serviceClient().getWithResponse(resourceGroupName, monitorName, ruleSetName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MonitoringTagRulesImpl((MonitoringTagRulesInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MonitoringTagRules get(String resourceGroupName, String monitorName, String ruleSetName) {
        MonitoringTagRulesInner inner = this.serviceClient().get(resourceGroupName, monitorName, ruleSetName);
        if (inner != null) {
            return new MonitoringTagRulesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, String ruleSetName) {
        this.serviceClient().delete(resourceGroupName, monitorName, ruleSetName);
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, String ruleSetName, Context context) {
        this.serviceClient().delete(resourceGroupName, monitorName, ruleSetName, context);
    }

    @Override
    public MonitoringTagRules getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String ruleSetName = ResourceManagerUtils.getValueFromIdByName(id, "tagRules");
        if (ruleSetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagRules'.", id)));
        }
        return (MonitoringTagRules)this.getWithResponse(resourceGroupName, monitorName, ruleSetName, Context.NONE).getValue();
    }

    @Override
    public Response<MonitoringTagRules> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String ruleSetName = ResourceManagerUtils.getValueFromIdByName(id, "tagRules");
        if (ruleSetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagRules'.", id)));
        }
        return this.getWithResponse(resourceGroupName, monitorName, ruleSetName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String ruleSetName = ResourceManagerUtils.getValueFromIdByName(id, "tagRules");
        if (ruleSetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagRules'.", id)));
        }
        this.delete(resourceGroupName, monitorName, ruleSetName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String ruleSetName = ResourceManagerUtils.getValueFromIdByName(id, "tagRules");
        if (ruleSetName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'tagRules'.", id)));
        }
        this.delete(resourceGroupName, monitorName, ruleSetName, context);
    }

    private TagRulesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public MonitoringTagRulesImpl define(String name) {
        return new MonitoringTagRulesImpl(name, this.manager());
    }
}

