/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.OrganizationsClient;
import com.azure.resourcemanager.elastic.fluent.models.ElasticMonitorResourceInner;
import com.azure.resourcemanager.elastic.fluent.models.ElasticOrganizationToAzureSubscriptionMappingResponseInner;
import com.azure.resourcemanager.elastic.fluent.models.UserApiKeyResponseInner;
import com.azure.resourcemanager.elastic.implementation.ElasticMonitorResourceImpl;
import com.azure.resourcemanager.elastic.implementation.ElasticOrganizationToAzureSubscriptionMappingResponseImpl;
import com.azure.resourcemanager.elastic.implementation.UserApiKeyResponseImpl;
import com.azure.resourcemanager.elastic.models.ElasticMonitorResource;
import com.azure.resourcemanager.elastic.models.ElasticOrganizationToAzureSubscriptionMappingResponse;
import com.azure.resourcemanager.elastic.models.Organizations;
import com.azure.resourcemanager.elastic.models.ResubscribeProperties;
import com.azure.resourcemanager.elastic.models.UserApiKeyResponse;
import com.azure.resourcemanager.elastic.models.UserEmailId;

public final class OrganizationsImpl
implements Organizations {
    private static final ClientLogger LOGGER = new ClientLogger(OrganizationsImpl.class);
    private final OrganizationsClient innerClient;
    private final ElasticManager serviceManager;

    public OrganizationsImpl(OrganizationsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<UserApiKeyResponse> getApiKeyWithResponse(UserEmailId body, Context context) {
        Response<UserApiKeyResponseInner> inner = this.serviceClient().getApiKeyWithResponse(body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new UserApiKeyResponseImpl((UserApiKeyResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public UserApiKeyResponse getApiKey() {
        UserApiKeyResponseInner inner = this.serviceClient().getApiKey();
        if (inner != null) {
            return new UserApiKeyResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ElasticOrganizationToAzureSubscriptionMappingResponse> getElasticToAzureSubscriptionMappingWithResponse(Context context) {
        Response<ElasticOrganizationToAzureSubscriptionMappingResponseInner> inner = this.serviceClient().getElasticToAzureSubscriptionMappingWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticOrganizationToAzureSubscriptionMappingResponseImpl((ElasticOrganizationToAzureSubscriptionMappingResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticOrganizationToAzureSubscriptionMappingResponse getElasticToAzureSubscriptionMapping() {
        ElasticOrganizationToAzureSubscriptionMappingResponseInner inner = this.serviceClient().getElasticToAzureSubscriptionMapping();
        if (inner != null) {
            return new ElasticOrganizationToAzureSubscriptionMappingResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticMonitorResource resubscribe(String resourceGroupName, String monitorName) {
        ElasticMonitorResourceInner inner = this.serviceClient().resubscribe(resourceGroupName, monitorName);
        if (inner != null) {
            return new ElasticMonitorResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ElasticMonitorResource resubscribe(String resourceGroupName, String monitorName, ResubscribeProperties body, Context context) {
        ElasticMonitorResourceInner inner = this.serviceClient().resubscribe(resourceGroupName, monitorName, body, context);
        if (inner != null) {
            return new ElasticMonitorResourceImpl(inner, this.manager());
        }
        return null;
    }

    private OrganizationsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

