/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.OperationsClient;
import com.azure.resourcemanager.elastic.fluent.models.OperationResultInner;
import com.azure.resourcemanager.elastic.implementation.OperationResultImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.OperationResult;
import com.azure.resourcemanager.elastic.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final ElasticManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationResult> list() {
        PagedIterable<OperationResultInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationResultImpl((OperationResultInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationResult> list(Context context) {
        PagedIterable<OperationResultInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationResultImpl((OperationResultInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

