/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.OpenAIsClient;
import com.azure.resourcemanager.elastic.fluent.models.OpenAIIntegrationRPModelInner;
import com.azure.resourcemanager.elastic.fluent.models.OpenAIIntegrationStatusResponseInner;
import com.azure.resourcemanager.elastic.implementation.OpenAIIntegrationRPModelImpl;
import com.azure.resourcemanager.elastic.implementation.OpenAIIntegrationStatusResponseImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationRPModel;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationStatusResponse;
import com.azure.resourcemanager.elastic.models.OpenAIs;

public final class OpenAIsImpl
implements OpenAIs {
    private static final ClientLogger LOGGER = new ClientLogger(OpenAIsImpl.class);
    private final OpenAIsClient innerClient;
    private final ElasticManager serviceManager;

    public OpenAIsImpl(OpenAIsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OpenAIIntegrationRPModel> list(String resourceGroupName, String monitorName) {
        PagedIterable<OpenAIIntegrationRPModelInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OpenAIIntegrationRPModelImpl((OpenAIIntegrationRPModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<OpenAIIntegrationRPModel> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<OpenAIIntegrationRPModelInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OpenAIIntegrationRPModelImpl((OpenAIIntegrationRPModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<OpenAIIntegrationRPModel> getWithResponse(String resourceGroupName, String monitorName, String integrationName, Context context) {
        Response<OpenAIIntegrationRPModelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, monitorName, integrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OpenAIIntegrationRPModelImpl((OpenAIIntegrationRPModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public OpenAIIntegrationRPModel get(String resourceGroupName, String monitorName, String integrationName) {
        OpenAIIntegrationRPModelInner inner = this.serviceClient().get(resourceGroupName, monitorName, integrationName);
        if (inner != null) {
            return new OpenAIIntegrationRPModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteWithResponse(String resourceGroupName, String monitorName, String integrationName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, monitorName, integrationName, context);
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, String integrationName) {
        this.serviceClient().delete(resourceGroupName, monitorName, integrationName);
    }

    @Override
    public Response<OpenAIIntegrationStatusResponse> getStatusWithResponse(String resourceGroupName, String monitorName, String integrationName, Context context) {
        Response<OpenAIIntegrationStatusResponseInner> inner = this.serviceClient().getStatusWithResponse(resourceGroupName, monitorName, integrationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OpenAIIntegrationStatusResponseImpl((OpenAIIntegrationStatusResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public OpenAIIntegrationStatusResponse getStatus(String resourceGroupName, String monitorName, String integrationName) {
        OpenAIIntegrationStatusResponseInner inner = this.serviceClient().getStatus(resourceGroupName, monitorName, integrationName);
        if (inner != null) {
            return new OpenAIIntegrationStatusResponseImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OpenAIIntegrationRPModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String integrationName = ResourceManagerUtils.getValueFromIdByName(id, "openAIIntegrations");
        if (integrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'openAIIntegrations'.", id)));
        }
        return (OpenAIIntegrationRPModel)this.getWithResponse(resourceGroupName, monitorName, integrationName, Context.NONE).getValue();
    }

    @Override
    public Response<OpenAIIntegrationRPModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String integrationName = ResourceManagerUtils.getValueFromIdByName(id, "openAIIntegrations");
        if (integrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'openAIIntegrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, monitorName, integrationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String integrationName = ResourceManagerUtils.getValueFromIdByName(id, "openAIIntegrations");
        if (integrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'openAIIntegrations'.", id)));
        }
        this.deleteWithResponse(resourceGroupName, monitorName, integrationName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String integrationName = ResourceManagerUtils.getValueFromIdByName(id, "openAIIntegrations");
        if (integrationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'openAIIntegrations'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, monitorName, integrationName, context);
    }

    private OpenAIsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public OpenAIIntegrationRPModelImpl define(String name) {
        return new OpenAIIntegrationRPModelImpl(name, this.manager());
    }
}

