/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.models.OpenAIIntegrationRPModelInner;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationProperties;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationRPModel;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationStatusResponse;

public final class OpenAIIntegrationRPModelImpl
implements OpenAIIntegrationRPModel,
OpenAIIntegrationRPModel.Definition,
OpenAIIntegrationRPModel.Update {
    private OpenAIIntegrationRPModelInner innerObject;
    private final ElasticManager serviceManager;
    private String resourceGroupName;
    private String monitorName;
    private String integrationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public OpenAIIntegrationProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public OpenAIIntegrationRPModelInner innerModel() {
        return this.innerObject;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public OpenAIIntegrationRPModelImpl withExistingMonitor(String resourceGroupName, String monitorName) {
        this.resourceGroupName = resourceGroupName;
        this.monitorName = monitorName;
        return this;
    }

    @Override
    public OpenAIIntegrationRPModel create() {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public OpenAIIntegrationRPModel create(Context context) {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, this.innerModel(), context).getValue());
        return this;
    }

    OpenAIIntegrationRPModelImpl(String name, ElasticManager serviceManager) {
        this.innerObject = new OpenAIIntegrationRPModelInner();
        this.serviceManager = serviceManager;
        this.integrationName = name;
    }

    @Override
    public OpenAIIntegrationRPModelImpl update() {
        return this;
    }

    @Override
    public OpenAIIntegrationRPModel apply() {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public OpenAIIntegrationRPModel apply(Context context) {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, this.innerModel(), context).getValue());
        return this;
    }

    OpenAIIntegrationRPModelImpl(OpenAIIntegrationRPModelInner innerObject, ElasticManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.monitorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "monitors");
        this.integrationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "openAIIntegrations");
    }

    @Override
    public OpenAIIntegrationRPModel refresh() {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().getWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public OpenAIIntegrationRPModel refresh(Context context) {
        this.innerObject = (OpenAIIntegrationRPModelInner)((Object)this.serviceManager.serviceClient().getOpenAIs().getWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, context).getValue());
        return this;
    }

    @Override
    public Response<OpenAIIntegrationStatusResponse> getStatusWithResponse(Context context) {
        return this.serviceManager.openAIs().getStatusWithResponse(this.resourceGroupName, this.monitorName, this.integrationName, context);
    }

    @Override
    public OpenAIIntegrationStatusResponse getStatus() {
        return this.serviceManager.openAIs().getStatus(this.resourceGroupName, this.monitorName, this.integrationName);
    }

    @Override
    public OpenAIIntegrationRPModelImpl withProperties(OpenAIIntegrationProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

