/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.MonitorsClient;
import com.azure.resourcemanager.elastic.fluent.models.ElasticMonitorResourceInner;
import com.azure.resourcemanager.elastic.implementation.ElasticMonitorResourceImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.ElasticMonitorResource;
import com.azure.resourcemanager.elastic.models.Monitors;

public final class MonitorsImpl
implements Monitors {
    private static final ClientLogger LOGGER = new ClientLogger(MonitorsImpl.class);
    private final MonitorsClient innerClient;
    private final ElasticManager serviceManager;

    public MonitorsImpl(MonitorsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ElasticMonitorResource> list() {
        PagedIterable<ElasticMonitorResourceInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticMonitorResourceImpl((ElasticMonitorResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticMonitorResource> list(Context context) {
        PagedIterable<ElasticMonitorResourceInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticMonitorResourceImpl((ElasticMonitorResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticMonitorResource> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ElasticMonitorResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticMonitorResourceImpl((ElasticMonitorResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ElasticMonitorResource> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ElasticMonitorResourceInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticMonitorResourceImpl((ElasticMonitorResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ElasticMonitorResource> getByResourceGroupWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<ElasticMonitorResourceInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticMonitorResourceImpl((ElasticMonitorResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticMonitorResource getByResourceGroup(String resourceGroupName, String monitorName) {
        ElasticMonitorResourceInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, monitorName);
        if (inner != null) {
            return new ElasticMonitorResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String monitorName) {
        this.serviceClient().delete(resourceGroupName, monitorName);
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, Context context) {
        this.serviceClient().delete(resourceGroupName, monitorName, context);
    }

    @Override
    public ElasticMonitorResource getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        return (ElasticMonitorResource)this.getByResourceGroupWithResponse(resourceGroupName, monitorName, Context.NONE).getValue();
    }

    @Override
    public Response<ElasticMonitorResource> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, monitorName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        this.delete(resourceGroupName, monitorName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        this.delete(resourceGroupName, monitorName, context);
    }

    private MonitorsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticMonitorResourceImpl define(String name) {
        return new ElasticMonitorResourceImpl(name, this.manager());
    }
}

