/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.models.MonitoringTagRulesInner;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.MonitoringTagRules;
import com.azure.resourcemanager.elastic.models.MonitoringTagRulesProperties;

public final class MonitoringTagRulesImpl
implements MonitoringTagRules,
MonitoringTagRules.Definition,
MonitoringTagRules.Update {
    private MonitoringTagRulesInner innerObject;
    private final ElasticManager serviceManager;
    private String resourceGroupName;
    private String monitorName;
    private String ruleSetName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public MonitoringTagRulesProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MonitoringTagRulesInner innerModel() {
        return this.innerObject;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public MonitoringTagRulesImpl withExistingMonitor(String resourceGroupName, String monitorName) {
        this.resourceGroupName = resourceGroupName;
        this.monitorName = monitorName;
        return this;
    }

    @Override
    public MonitoringTagRules create() {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public MonitoringTagRules create(Context context) {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, this.innerModel(), context).getValue());
        return this;
    }

    MonitoringTagRulesImpl(String name, ElasticManager serviceManager) {
        this.innerObject = new MonitoringTagRulesInner();
        this.serviceManager = serviceManager;
        this.ruleSetName = name;
    }

    @Override
    public MonitoringTagRulesImpl update() {
        return this;
    }

    @Override
    public MonitoringTagRules apply() {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public MonitoringTagRules apply(Context context) {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().createOrUpdateWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, this.innerModel(), context).getValue());
        return this;
    }

    MonitoringTagRulesImpl(MonitoringTagRulesInner innerObject, ElasticManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.monitorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "monitors");
        this.ruleSetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "tagRules");
    }

    @Override
    public MonitoringTagRules refresh() {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().getWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MonitoringTagRules refresh(Context context) {
        this.innerObject = (MonitoringTagRulesInner)((Object)this.serviceManager.serviceClient().getTagRules().getWithResponse(this.resourceGroupName, this.monitorName, this.ruleSetName, context).getValue());
        return this;
    }

    @Override
    public MonitoringTagRulesImpl withProperties(MonitoringTagRulesProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

