/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.MonitoredSubscriptionsClient;
import com.azure.resourcemanager.elastic.fluent.models.MonitoredSubscriptionPropertiesInner;
import com.azure.resourcemanager.elastic.implementation.MonitoredSubscriptionPropertiesImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.MonitoredSubscriptionProperties;
import com.azure.resourcemanager.elastic.models.MonitoredSubscriptions;

public final class MonitoredSubscriptionsImpl
implements MonitoredSubscriptions {
    private static final ClientLogger LOGGER = new ClientLogger(MonitoredSubscriptionsImpl.class);
    private final MonitoredSubscriptionsClient innerClient;
    private final ElasticManager serviceManager;

    public MonitoredSubscriptionsImpl(MonitoredSubscriptionsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<MonitoredSubscriptionProperties> list(String resourceGroupName, String monitorName) {
        PagedIterable<MonitoredSubscriptionPropertiesInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoredSubscriptionPropertiesImpl((MonitoredSubscriptionPropertiesInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<MonitoredSubscriptionProperties> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<MonitoredSubscriptionPropertiesInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoredSubscriptionPropertiesImpl((MonitoredSubscriptionPropertiesInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<MonitoredSubscriptionProperties> getWithResponse(String resourceGroupName, String monitorName, String configurationName, Context context) {
        Response<MonitoredSubscriptionPropertiesInner> inner = this.serviceClient().getWithResponse(resourceGroupName, monitorName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new MonitoredSubscriptionPropertiesImpl((MonitoredSubscriptionPropertiesInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public MonitoredSubscriptionProperties get(String resourceGroupName, String monitorName, String configurationName) {
        MonitoredSubscriptionPropertiesInner inner = this.serviceClient().get(resourceGroupName, monitorName, configurationName);
        if (inner != null) {
            return new MonitoredSubscriptionPropertiesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, String configurationName) {
        this.serviceClient().delete(resourceGroupName, monitorName, configurationName);
    }

    @Override
    public void delete(String resourceGroupName, String monitorName, String configurationName, Context context) {
        this.serviceClient().delete(resourceGroupName, monitorName, configurationName, context);
    }

    @Override
    public MonitoredSubscriptionProperties getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "monitoredSubscriptions");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitoredSubscriptions'.", id)));
        }
        return (MonitoredSubscriptionProperties)this.getWithResponse(resourceGroupName, monitorName, configurationName, Context.NONE).getValue();
    }

    @Override
    public Response<MonitoredSubscriptionProperties> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "monitoredSubscriptions");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitoredSubscriptions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, monitorName, configurationName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "monitoredSubscriptions");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitoredSubscriptions'.", id)));
        }
        this.delete(resourceGroupName, monitorName, configurationName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String monitorName = ResourceManagerUtils.getValueFromIdByName(id, "monitors");
        if (monitorName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitors'.", id)));
        }
        String configurationName = ResourceManagerUtils.getValueFromIdByName(id, "monitoredSubscriptions");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'monitoredSubscriptions'.", id)));
        }
        this.delete(resourceGroupName, monitorName, configurationName, context);
    }

    private MonitoredSubscriptionsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public MonitoredSubscriptionPropertiesImpl define(String name) {
        return new MonitoredSubscriptionPropertiesImpl(name, this.manager());
    }
}

