/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.models.MonitoredSubscriptionPropertiesInner;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.MonitoredSubscriptionProperties;
import com.azure.resourcemanager.elastic.models.SubscriptionList;

public final class MonitoredSubscriptionPropertiesImpl
implements MonitoredSubscriptionProperties,
MonitoredSubscriptionProperties.Definition,
MonitoredSubscriptionProperties.Update {
    private MonitoredSubscriptionPropertiesInner innerObject;
    private final ElasticManager serviceManager;
    private String resourceGroupName;
    private String monitorName;
    private String configurationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SubscriptionList properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public MonitoredSubscriptionPropertiesInner innerModel() {
        return this.innerObject;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public MonitoredSubscriptionPropertiesImpl withExistingMonitor(String resourceGroupName, String monitorName) {
        this.resourceGroupName = resourceGroupName;
        this.monitorName = monitorName;
        return this;
    }

    @Override
    public MonitoredSubscriptionProperties create() {
        this.innerObject = this.serviceManager.serviceClient().getMonitoredSubscriptions().createorUpdate(this.resourceGroupName, this.monitorName, this.configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public MonitoredSubscriptionProperties create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMonitoredSubscriptions().createorUpdate(this.resourceGroupName, this.monitorName, this.configurationName, this.innerModel(), context);
        return this;
    }

    MonitoredSubscriptionPropertiesImpl(String name, ElasticManager serviceManager) {
        this.innerObject = new MonitoredSubscriptionPropertiesInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
    }

    @Override
    public MonitoredSubscriptionPropertiesImpl update() {
        return this;
    }

    @Override
    public MonitoredSubscriptionProperties apply() {
        this.innerObject = this.serviceManager.serviceClient().getMonitoredSubscriptions().update(this.resourceGroupName, this.monitorName, this.configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public MonitoredSubscriptionProperties apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMonitoredSubscriptions().update(this.resourceGroupName, this.monitorName, this.configurationName, this.innerModel(), context);
        return this;
    }

    MonitoredSubscriptionPropertiesImpl(MonitoredSubscriptionPropertiesInner innerObject, ElasticManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.monitorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "monitors");
        this.configurationName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "monitoredSubscriptions");
    }

    @Override
    public MonitoredSubscriptionProperties refresh() {
        this.innerObject = (MonitoredSubscriptionPropertiesInner)((Object)this.serviceManager.serviceClient().getMonitoredSubscriptions().getWithResponse(this.resourceGroupName, this.monitorName, this.configurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public MonitoredSubscriptionProperties refresh(Context context) {
        this.innerObject = (MonitoredSubscriptionPropertiesInner)((Object)this.serviceManager.serviceClient().getMonitoredSubscriptions().getWithResponse(this.resourceGroupName, this.monitorName, this.configurationName, context).getValue());
        return this;
    }

    @Override
    public MonitoredSubscriptionPropertiesImpl withProperties(SubscriptionList properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

