/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.MonitoredResourcesClient;
import com.azure.resourcemanager.elastic.fluent.models.MonitoredResourceInner;
import com.azure.resourcemanager.elastic.implementation.MonitoredResourceImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.MonitoredResource;
import com.azure.resourcemanager.elastic.models.MonitoredResources;

public final class MonitoredResourcesImpl
implements MonitoredResources {
    private static final ClientLogger LOGGER = new ClientLogger(MonitoredResourcesImpl.class);
    private final MonitoredResourcesClient innerClient;
    private final ElasticManager serviceManager;

    public MonitoredResourcesImpl(MonitoredResourcesClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<MonitoredResource> list(String resourceGroupName, String monitorName) {
        PagedIterable<MonitoredResourceInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoredResourceImpl((MonitoredResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<MonitoredResource> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<MonitoredResourceInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new MonitoredResourceImpl((MonitoredResourceInner)inner1, this.manager()));
    }

    private MonitoredResourcesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

