/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.MonitorOperationsClient;
import com.azure.resourcemanager.elastic.models.ElasticMonitorUpgrade;
import com.azure.resourcemanager.elastic.models.MonitorOperations;

public final class MonitorOperationsImpl
implements MonitorOperations {
    private static final ClientLogger LOGGER = new ClientLogger(MonitorOperationsImpl.class);
    private final MonitorOperationsClient innerClient;
    private final ElasticManager serviceManager;

    public MonitorOperationsImpl(MonitorOperationsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void upgrade(String resourceGroupName, String monitorName) {
        this.serviceClient().upgrade(resourceGroupName, monitorName);
    }

    @Override
    public void upgrade(String resourceGroupName, String monitorName, ElasticMonitorUpgrade body, Context context) {
        this.serviceClient().upgrade(resourceGroupName, monitorName, body, context);
    }

    private MonitorOperationsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

