/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.ListAssociatedTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.models.ElasticTrafficFilterResponseInner;
import com.azure.resourcemanager.elastic.implementation.ElasticTrafficFilterResponseImpl;
import com.azure.resourcemanager.elastic.models.ElasticTrafficFilterResponse;
import com.azure.resourcemanager.elastic.models.ListAssociatedTrafficFilters;

public final class ListAssociatedTrafficFiltersImpl
implements ListAssociatedTrafficFilters {
    private static final ClientLogger LOGGER = new ClientLogger(ListAssociatedTrafficFiltersImpl.class);
    private final ListAssociatedTrafficFiltersClient innerClient;
    private final ElasticManager serviceManager;

    public ListAssociatedTrafficFiltersImpl(ListAssociatedTrafficFiltersClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticTrafficFilterResponse> listWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<ElasticTrafficFilterResponseInner> inner = this.serviceClient().listWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticTrafficFilterResponseImpl((ElasticTrafficFilterResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticTrafficFilterResponse list(String resourceGroupName, String monitorName) {
        ElasticTrafficFilterResponseInner inner = this.serviceClient().list(resourceGroupName, monitorName);
        if (inner != null) {
            return new ElasticTrafficFilterResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ListAssociatedTrafficFiltersClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

