/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.ExternalUsersClient;
import com.azure.resourcemanager.elastic.fluent.models.ExternalUserCreationResponseInner;
import com.azure.resourcemanager.elastic.implementation.ExternalUserCreationResponseImpl;
import com.azure.resourcemanager.elastic.models.ExternalUserCreationResponse;
import com.azure.resourcemanager.elastic.models.ExternalUserInfo;
import com.azure.resourcemanager.elastic.models.ExternalUsers;

public final class ExternalUsersImpl
implements ExternalUsers {
    private static final ClientLogger LOGGER = new ClientLogger(ExternalUsersImpl.class);
    private final ExternalUsersClient innerClient;
    private final ElasticManager serviceManager;

    public ExternalUsersImpl(ExternalUsersClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ExternalUserCreationResponse> createOrUpdateWithResponse(String resourceGroupName, String monitorName, ExternalUserInfo body, Context context) {
        Response<ExternalUserCreationResponseInner> inner = this.serviceClient().createOrUpdateWithResponse(resourceGroupName, monitorName, body, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExternalUserCreationResponseImpl((ExternalUserCreationResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ExternalUserCreationResponse createOrUpdate(String resourceGroupName, String monitorName) {
        ExternalUserCreationResponseInner inner = this.serviceClient().createOrUpdate(resourceGroupName, monitorName);
        if (inner != null) {
            return new ExternalUserCreationResponseImpl(inner, this.manager());
        }
        return null;
    }

    private ExternalUsersClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

