/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.ElasticVersionsClient;
import com.azure.resourcemanager.elastic.fluent.models.ElasticVersionListFormatInner;
import com.azure.resourcemanager.elastic.implementation.ElasticVersionListFormatImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.ElasticVersionListFormat;
import com.azure.resourcemanager.elastic.models.ElasticVersions;

public final class ElasticVersionsImpl
implements ElasticVersions {
    private static final ClientLogger LOGGER = new ClientLogger(ElasticVersionsImpl.class);
    private final ElasticVersionsClient innerClient;
    private final ElasticManager serviceManager;

    public ElasticVersionsImpl(ElasticVersionsClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ElasticVersionListFormat> list(String region) {
        PagedIterable<ElasticVersionListFormatInner> inner = this.serviceClient().list(region);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVersionListFormatImpl((ElasticVersionListFormatInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ElasticVersionListFormat> list(String region, Context context) {
        PagedIterable<ElasticVersionListFormatInner> inner = this.serviceClient().list(region, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ElasticVersionListFormatImpl((ElasticVersionListFormatInner)inner1, this.manager()));
    }

    private ElasticVersionsClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

