/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.models.ElasticMonitorResourceInner;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.ElasticMonitorResource;
import com.azure.resourcemanager.elastic.models.ElasticMonitorResourceUpdateParameters;
import com.azure.resourcemanager.elastic.models.IdentityProperties;
import com.azure.resourcemanager.elastic.models.MonitorProperties;
import com.azure.resourcemanager.elastic.models.ResourceSku;
import java.util.Collections;
import java.util.Map;

public final class ElasticMonitorResourceImpl
implements ElasticMonitorResource,
ElasticMonitorResource.Definition,
ElasticMonitorResource.Update {
    private ElasticMonitorResourceInner innerObject;
    private final ElasticManager serviceManager;
    private String resourceGroupName;
    private String monitorName;
    private ElasticMonitorResourceUpdateParameters updateBody;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String kind() {
        return this.innerModel().kind();
    }

    @Override
    public ResourceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public MonitorProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public IdentityProperties identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ElasticMonitorResourceInner innerModel() {
        return this.innerObject;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }

    @Override
    public ElasticMonitorResourceImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ElasticMonitorResource create() {
        this.innerObject = this.serviceManager.serviceClient().getMonitors().create(this.resourceGroupName, this.monitorName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ElasticMonitorResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMonitors().create(this.resourceGroupName, this.monitorName, this.innerModel(), context);
        return this;
    }

    ElasticMonitorResourceImpl(String name, ElasticManager serviceManager) {
        this.innerObject = new ElasticMonitorResourceInner();
        this.serviceManager = serviceManager;
        this.monitorName = name;
    }

    @Override
    public ElasticMonitorResourceImpl update() {
        this.updateBody = new ElasticMonitorResourceUpdateParameters();
        return this;
    }

    @Override
    public ElasticMonitorResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getMonitors().update(this.resourceGroupName, this.monitorName, this.updateBody, Context.NONE);
        return this;
    }

    @Override
    public ElasticMonitorResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getMonitors().update(this.resourceGroupName, this.monitorName, this.updateBody, context);
        return this;
    }

    ElasticMonitorResourceImpl(ElasticMonitorResourceInner innerObject, ElasticManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.monitorName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "monitors");
    }

    @Override
    public ElasticMonitorResource refresh() {
        this.innerObject = (ElasticMonitorResourceInner)((Object)this.serviceManager.serviceClient().getMonitors().getByResourceGroupWithResponse(this.resourceGroupName, this.monitorName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ElasticMonitorResource refresh(Context context) {
        this.innerObject = (ElasticMonitorResourceInner)((Object)this.serviceManager.serviceClient().getMonitors().getByResourceGroupWithResponse(this.resourceGroupName, this.monitorName, context).getValue());
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateBody.withTags(tags);
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withKind(String kind) {
        this.innerModel().withKind(kind);
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withSku(ResourceSku sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withProperties(MonitorProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ElasticMonitorResourceImpl withIdentity(IdentityProperties identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

