/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.elastic.fluent.AllTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.AssociateTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.BillingInfoesClient;
import com.azure.resourcemanager.elastic.fluent.ConnectedPartnerResourcesClient;
import com.azure.resourcemanager.elastic.fluent.CreateAndAssociateIpFiltersClient;
import com.azure.resourcemanager.elastic.fluent.CreateAndAssociatePLFiltersClient;
import com.azure.resourcemanager.elastic.fluent.DeploymentInfoesClient;
import com.azure.resourcemanager.elastic.fluent.DetachAndDeleteTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.DetachTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.ElasticManagementClient;
import com.azure.resourcemanager.elastic.fluent.ElasticVersionsClient;
import com.azure.resourcemanager.elastic.fluent.ExternalUsersClient;
import com.azure.resourcemanager.elastic.fluent.ListAssociatedTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.MonitorOperationsClient;
import com.azure.resourcemanager.elastic.fluent.MonitoredResourcesClient;
import com.azure.resourcemanager.elastic.fluent.MonitoredSubscriptionsClient;
import com.azure.resourcemanager.elastic.fluent.MonitorsClient;
import com.azure.resourcemanager.elastic.fluent.OpenAIsClient;
import com.azure.resourcemanager.elastic.fluent.OperationsClient;
import com.azure.resourcemanager.elastic.fluent.OrganizationsClient;
import com.azure.resourcemanager.elastic.fluent.TagRulesClient;
import com.azure.resourcemanager.elastic.fluent.TrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.UpgradableVersionsClient;
import com.azure.resourcemanager.elastic.fluent.VMCollectionsClient;
import com.azure.resourcemanager.elastic.fluent.VMHostsClient;
import com.azure.resourcemanager.elastic.fluent.VMIngestionsClient;
import com.azure.resourcemanager.elastic.implementation.AllTrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.AssociateTrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.BillingInfoesClientImpl;
import com.azure.resourcemanager.elastic.implementation.ConnectedPartnerResourcesClientImpl;
import com.azure.resourcemanager.elastic.implementation.CreateAndAssociateIpFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.CreateAndAssociatePLFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.DeploymentInfoesClientImpl;
import com.azure.resourcemanager.elastic.implementation.DetachAndDeleteTrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.DetachTrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.ElasticManagementClientBuilder;
import com.azure.resourcemanager.elastic.implementation.ElasticVersionsClientImpl;
import com.azure.resourcemanager.elastic.implementation.ExternalUsersClientImpl;
import com.azure.resourcemanager.elastic.implementation.ListAssociatedTrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.MonitorOperationsClientImpl;
import com.azure.resourcemanager.elastic.implementation.MonitoredResourcesClientImpl;
import com.azure.resourcemanager.elastic.implementation.MonitoredSubscriptionsClientImpl;
import com.azure.resourcemanager.elastic.implementation.MonitorsClientImpl;
import com.azure.resourcemanager.elastic.implementation.OpenAIsClientImpl;
import com.azure.resourcemanager.elastic.implementation.OperationsClientImpl;
import com.azure.resourcemanager.elastic.implementation.OrganizationsClientImpl;
import com.azure.resourcemanager.elastic.implementation.TagRulesClientImpl;
import com.azure.resourcemanager.elastic.implementation.TrafficFiltersClientImpl;
import com.azure.resourcemanager.elastic.implementation.UpgradableVersionsClientImpl;
import com.azure.resourcemanager.elastic.implementation.VMCollectionsClientImpl;
import com.azure.resourcemanager.elastic.implementation.VMHostsClientImpl;
import com.azure.resourcemanager.elastic.implementation.VMIngestionsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ElasticManagementClientBuilder.class)
public final class ElasticManagementClientImpl
implements ElasticManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final MonitorsClient monitors;
    private final ElasticVersionsClient elasticVersions;
    private final MonitoredSubscriptionsClient monitoredSubscriptions;
    private final MonitoredResourcesClient monitoredResources;
    private final DeploymentInfoesClient deploymentInfoes;
    private final ExternalUsersClient externalUsers;
    private final BillingInfoesClient billingInfoes;
    private final ConnectedPartnerResourcesClient connectedPartnerResources;
    private final OpenAIsClient openAIs;
    private final TagRulesClient tagRules;
    private final VMHostsClient vMHosts;
    private final VMIngestionsClient vMIngestions;
    private final VMCollectionsClient vMCollections;
    private final UpgradableVersionsClient upgradableVersions;
    private final MonitorOperationsClient monitorOperations;
    private final AllTrafficFiltersClient allTrafficFilters;
    private final ListAssociatedTrafficFiltersClient listAssociatedTrafficFilters;
    private final CreateAndAssociateIpFiltersClient createAndAssociateIpFilters;
    private final CreateAndAssociatePLFiltersClient createAndAssociatePLFilters;
    private final AssociateTrafficFiltersClient associateTrafficFilters;
    private final DetachAndDeleteTrafficFiltersClient detachAndDeleteTrafficFilters;
    private final DetachTrafficFiltersClient detachTrafficFilters;
    private final TrafficFiltersClient trafficFilters;
    private final OrganizationsClient organizations;
    private static final ClientLogger LOGGER = new ClientLogger(ElasticManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public MonitorsClient getMonitors() {
        return this.monitors;
    }

    @Override
    public ElasticVersionsClient getElasticVersions() {
        return this.elasticVersions;
    }

    @Override
    public MonitoredSubscriptionsClient getMonitoredSubscriptions() {
        return this.monitoredSubscriptions;
    }

    @Override
    public MonitoredResourcesClient getMonitoredResources() {
        return this.monitoredResources;
    }

    @Override
    public DeploymentInfoesClient getDeploymentInfoes() {
        return this.deploymentInfoes;
    }

    @Override
    public ExternalUsersClient getExternalUsers() {
        return this.externalUsers;
    }

    @Override
    public BillingInfoesClient getBillingInfoes() {
        return this.billingInfoes;
    }

    @Override
    public ConnectedPartnerResourcesClient getConnectedPartnerResources() {
        return this.connectedPartnerResources;
    }

    @Override
    public OpenAIsClient getOpenAIs() {
        return this.openAIs;
    }

    @Override
    public TagRulesClient getTagRules() {
        return this.tagRules;
    }

    @Override
    public VMHostsClient getVMHosts() {
        return this.vMHosts;
    }

    @Override
    public VMIngestionsClient getVMIngestions() {
        return this.vMIngestions;
    }

    @Override
    public VMCollectionsClient getVMCollections() {
        return this.vMCollections;
    }

    @Override
    public UpgradableVersionsClient getUpgradableVersions() {
        return this.upgradableVersions;
    }

    @Override
    public MonitorOperationsClient getMonitorOperations() {
        return this.monitorOperations;
    }

    @Override
    public AllTrafficFiltersClient getAllTrafficFilters() {
        return this.allTrafficFilters;
    }

    @Override
    public ListAssociatedTrafficFiltersClient getListAssociatedTrafficFilters() {
        return this.listAssociatedTrafficFilters;
    }

    @Override
    public CreateAndAssociateIpFiltersClient getCreateAndAssociateIpFilters() {
        return this.createAndAssociateIpFilters;
    }

    @Override
    public CreateAndAssociatePLFiltersClient getCreateAndAssociatePLFilters() {
        return this.createAndAssociatePLFilters;
    }

    @Override
    public AssociateTrafficFiltersClient getAssociateTrafficFilters() {
        return this.associateTrafficFilters;
    }

    @Override
    public DetachAndDeleteTrafficFiltersClient getDetachAndDeleteTrafficFilters() {
        return this.detachAndDeleteTrafficFilters;
    }

    @Override
    public DetachTrafficFiltersClient getDetachTrafficFilters() {
        return this.detachTrafficFilters;
    }

    @Override
    public TrafficFiltersClient getTrafficFilters() {
        return this.trafficFilters;
    }

    @Override
    public OrganizationsClient getOrganizations() {
        return this.organizations;
    }

    ElasticManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-06-01";
        this.operations = new OperationsClientImpl(this);
        this.monitors = new MonitorsClientImpl(this);
        this.elasticVersions = new ElasticVersionsClientImpl(this);
        this.monitoredSubscriptions = new MonitoredSubscriptionsClientImpl(this);
        this.monitoredResources = new MonitoredResourcesClientImpl(this);
        this.deploymentInfoes = new DeploymentInfoesClientImpl(this);
        this.externalUsers = new ExternalUsersClientImpl(this);
        this.billingInfoes = new BillingInfoesClientImpl(this);
        this.connectedPartnerResources = new ConnectedPartnerResourcesClientImpl(this);
        this.openAIs = new OpenAIsClientImpl(this);
        this.tagRules = new TagRulesClientImpl(this);
        this.vMHosts = new VMHostsClientImpl(this);
        this.vMIngestions = new VMIngestionsClientImpl(this);
        this.vMCollections = new VMCollectionsClientImpl(this);
        this.upgradableVersions = new UpgradableVersionsClientImpl(this);
        this.monitorOperations = new MonitorOperationsClientImpl(this);
        this.allTrafficFilters = new AllTrafficFiltersClientImpl(this);
        this.listAssociatedTrafficFilters = new ListAssociatedTrafficFiltersClientImpl(this);
        this.createAndAssociateIpFilters = new CreateAndAssociateIpFiltersClientImpl(this);
        this.createAndAssociatePLFilters = new CreateAndAssociatePLFiltersClientImpl(this);
        this.associateTrafficFilters = new AssociateTrafficFiltersClientImpl(this);
        this.detachAndDeleteTrafficFilters = new DetachAndDeleteTrafficFiltersClientImpl(this);
        this.detachTrafficFilters = new DetachTrafficFiltersClientImpl(this);
        this.trafficFilters = new TrafficFiltersClientImpl(this);
        this.organizations = new OrganizationsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

