/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.DeploymentInfoesClient;
import com.azure.resourcemanager.elastic.fluent.models.DeploymentInfoResponseInner;
import com.azure.resourcemanager.elastic.implementation.DeploymentInfoResponseImpl;
import com.azure.resourcemanager.elastic.models.DeploymentInfoResponse;
import com.azure.resourcemanager.elastic.models.DeploymentInfoes;

public final class DeploymentInfoesImpl
implements DeploymentInfoes {
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentInfoesImpl.class);
    private final DeploymentInfoesClient innerClient;
    private final ElasticManager serviceManager;

    public DeploymentInfoesImpl(DeploymentInfoesClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DeploymentInfoResponse> listWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<DeploymentInfoResponseInner> inner = this.serviceClient().listWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeploymentInfoResponseImpl((DeploymentInfoResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeploymentInfoResponse list(String resourceGroupName, String monitorName) {
        DeploymentInfoResponseInner inner = this.serviceClient().list(resourceGroupName, monitorName);
        if (inner != null) {
            return new DeploymentInfoResponseImpl(inner, this.manager());
        }
        return null;
    }

    private DeploymentInfoesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

