/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.ConnectedPartnerResourcesClient;
import com.azure.resourcemanager.elastic.fluent.models.ConnectedPartnerResourcesListFormatInner;
import com.azure.resourcemanager.elastic.implementation.ConnectedPartnerResourcesListFormatImpl;
import com.azure.resourcemanager.elastic.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.elastic.models.ConnectedPartnerResources;
import com.azure.resourcemanager.elastic.models.ConnectedPartnerResourcesListFormat;

public final class ConnectedPartnerResourcesImpl
implements ConnectedPartnerResources {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectedPartnerResourcesImpl.class);
    private final ConnectedPartnerResourcesClient innerClient;
    private final ElasticManager serviceManager;

    public ConnectedPartnerResourcesImpl(ConnectedPartnerResourcesClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ConnectedPartnerResourcesListFormat> list(String resourceGroupName, String monitorName) {
        PagedIterable<ConnectedPartnerResourcesListFormatInner> inner = this.serviceClient().list(resourceGroupName, monitorName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectedPartnerResourcesListFormatImpl((ConnectedPartnerResourcesListFormatInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ConnectedPartnerResourcesListFormat> list(String resourceGroupName, String monitorName, Context context) {
        PagedIterable<ConnectedPartnerResourcesListFormatInner> inner = this.serviceClient().list(resourceGroupName, monitorName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConnectedPartnerResourcesListFormatImpl((ConnectedPartnerResourcesListFormatInner)inner1, this.manager()));
    }

    private ConnectedPartnerResourcesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

