/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.BillingInfoesClient;
import com.azure.resourcemanager.elastic.fluent.models.BillingInfoResponseInner;
import com.azure.resourcemanager.elastic.implementation.BillingInfoResponseImpl;
import com.azure.resourcemanager.elastic.models.BillingInfoResponse;
import com.azure.resourcemanager.elastic.models.BillingInfoes;

public final class BillingInfoesImpl
implements BillingInfoes {
    private static final ClientLogger LOGGER = new ClientLogger(BillingInfoesImpl.class);
    private final BillingInfoesClient innerClient;
    private final ElasticManager serviceManager;

    public BillingInfoesImpl(BillingInfoesClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<BillingInfoResponse> getWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<BillingInfoResponseInner> inner = this.serviceClient().getWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new BillingInfoResponseImpl((BillingInfoResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public BillingInfoResponse get(String resourceGroupName, String monitorName) {
        BillingInfoResponseInner inner = this.serviceClient().get(resourceGroupName, monitorName);
        if (inner != null) {
            return new BillingInfoResponseImpl(inner, this.manager());
        }
        return null;
    }

    private BillingInfoesClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

