/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.ElasticManager;
import com.azure.resourcemanager.elastic.fluent.AllTrafficFiltersClient;
import com.azure.resourcemanager.elastic.fluent.models.ElasticTrafficFilterResponseInner;
import com.azure.resourcemanager.elastic.implementation.ElasticTrafficFilterResponseImpl;
import com.azure.resourcemanager.elastic.models.AllTrafficFilters;
import com.azure.resourcemanager.elastic.models.ElasticTrafficFilterResponse;

public final class AllTrafficFiltersImpl
implements AllTrafficFilters {
    private static final ClientLogger LOGGER = new ClientLogger(AllTrafficFiltersImpl.class);
    private final AllTrafficFiltersClient innerClient;
    private final ElasticManager serviceManager;

    public AllTrafficFiltersImpl(AllTrafficFiltersClient innerClient, ElasticManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ElasticTrafficFilterResponse> listWithResponse(String resourceGroupName, String monitorName, Context context) {
        Response<ElasticTrafficFilterResponseInner> inner = this.serviceClient().listWithResponse(resourceGroupName, monitorName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ElasticTrafficFilterResponseImpl((ElasticTrafficFilterResponseInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ElasticTrafficFilterResponse list(String resourceGroupName, String monitorName) {
        ElasticTrafficFilterResponseInner inner = this.serviceClient().list(resourceGroupName, monitorName);
        if (inner != null) {
            return new ElasticTrafficFilterResponseImpl(inner, this.manager());
        }
        return null;
    }

    private AllTrafficFiltersClient serviceClient() {
        return this.innerClient;
    }

    private ElasticManager manager() {
        return this.serviceManager;
    }
}

