/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.OperationDisplay;
import java.io.IOException;

public final class OperationResultInner
implements JsonSerializable<OperationResultInner> {
    private String name;
    private Boolean isDataAction;
    private OperationDisplay display;
    private String origin;

    public String name() {
        return this.name;
    }

    public OperationResultInner withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationResultInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public OperationResultInner withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationResultInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        return jsonWriter.writeEndObject();
    }

    public static OperationResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationResultInner)jsonReader.readObject(reader -> {
            OperationResultInner deserializedOperationResultInner = new OperationResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationResultInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationResultInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationResultInner.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationResultInner.origin = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationResultInner;
        });
    }
}

