/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.OpenAIIntegrationProperties;
import java.io.IOException;

public final class OpenAIIntegrationRPModelInner
extends ProxyResource {
    private OpenAIIntegrationProperties properties;
    private String type;
    private String name;
    private String id;

    public OpenAIIntegrationProperties properties() {
        return this.properties;
    }

    public OpenAIIntegrationRPModelInner withProperties(OpenAIIntegrationProperties properties) {
        this.properties = properties;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static OpenAIIntegrationRPModelInner fromJson(JsonReader jsonReader) throws IOException {
        return (OpenAIIntegrationRPModelInner)((Object)jsonReader.readObject(reader -> {
            OpenAIIntegrationRPModelInner deserializedOpenAIIntegrationRPModelInner = new OpenAIIntegrationRPModelInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedOpenAIIntegrationRPModelInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOpenAIIntegrationRPModelInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOpenAIIntegrationRPModelInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOpenAIIntegrationRPModelInner.properties = OpenAIIntegrationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenAIIntegrationRPModelInner;
        }));
    }
}

