/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.elastic.models.IdentityProperties;
import com.azure.resourcemanager.elastic.models.MonitorProperties;
import com.azure.resourcemanager.elastic.models.ResourceSku;
import java.io.IOException;
import java.util.Map;

public final class ElasticMonitorResourceInner
extends Resource {
    private String kind;
    private ResourceSku sku;
    private MonitorProperties properties;
    private IdentityProperties identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String kind() {
        return this.kind;
    }

    public ElasticMonitorResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public ResourceSku sku() {
        return this.sku;
    }

    public ElasticMonitorResourceInner withSku(ResourceSku sku) {
        this.sku = sku;
        return this;
    }

    public MonitorProperties properties() {
        return this.properties;
    }

    public ElasticMonitorResourceInner withProperties(MonitorProperties properties) {
        this.properties = properties;
        return this;
    }

    public IdentityProperties identity() {
        return this.identity;
    }

    public ElasticMonitorResourceInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ElasticMonitorResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ElasticMonitorResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("kind", this.kind);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static ElasticMonitorResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (ElasticMonitorResourceInner)((Object)jsonReader.readObject(reader -> {
            ElasticMonitorResourceInner deserializedElasticMonitorResourceInner = new ElasticMonitorResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticMonitorResourceInner.withTags(tags);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.kind = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.sku = ResourceSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.properties = MonitorProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.identity = IdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedElasticMonitorResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticMonitorResourceInner;
        }));
    }
}

