/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.elastic;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.elastic.fluent.ElasticManagementClient;
import com.azure.resourcemanager.elastic.implementation.AllTrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.AssociateTrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.BillingInfoesImpl;
import com.azure.resourcemanager.elastic.implementation.ConnectedPartnerResourcesImpl;
import com.azure.resourcemanager.elastic.implementation.CreateAndAssociateIpFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.CreateAndAssociatePLFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.DeploymentInfoesImpl;
import com.azure.resourcemanager.elastic.implementation.DetachAndDeleteTrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.DetachTrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.ElasticManagementClientBuilder;
import com.azure.resourcemanager.elastic.implementation.ElasticVersionsImpl;
import com.azure.resourcemanager.elastic.implementation.ExternalUsersImpl;
import com.azure.resourcemanager.elastic.implementation.ListAssociatedTrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.MonitorOperationsImpl;
import com.azure.resourcemanager.elastic.implementation.MonitoredResourcesImpl;
import com.azure.resourcemanager.elastic.implementation.MonitoredSubscriptionsImpl;
import com.azure.resourcemanager.elastic.implementation.MonitorsImpl;
import com.azure.resourcemanager.elastic.implementation.OpenAIsImpl;
import com.azure.resourcemanager.elastic.implementation.OperationsImpl;
import com.azure.resourcemanager.elastic.implementation.OrganizationsImpl;
import com.azure.resourcemanager.elastic.implementation.TagRulesImpl;
import com.azure.resourcemanager.elastic.implementation.TrafficFiltersImpl;
import com.azure.resourcemanager.elastic.implementation.UpgradableVersionsImpl;
import com.azure.resourcemanager.elastic.implementation.VMCollectionsImpl;
import com.azure.resourcemanager.elastic.implementation.VMHostsImpl;
import com.azure.resourcemanager.elastic.implementation.VMIngestionsImpl;
import com.azure.resourcemanager.elastic.models.AllTrafficFilters;
import com.azure.resourcemanager.elastic.models.AssociateTrafficFilters;
import com.azure.resourcemanager.elastic.models.BillingInfoes;
import com.azure.resourcemanager.elastic.models.ConnectedPartnerResources;
import com.azure.resourcemanager.elastic.models.CreateAndAssociateIpFilters;
import com.azure.resourcemanager.elastic.models.CreateAndAssociatePLFilters;
import com.azure.resourcemanager.elastic.models.DeploymentInfoes;
import com.azure.resourcemanager.elastic.models.DetachAndDeleteTrafficFilters;
import com.azure.resourcemanager.elastic.models.DetachTrafficFilters;
import com.azure.resourcemanager.elastic.models.ElasticVersions;
import com.azure.resourcemanager.elastic.models.ExternalUsers;
import com.azure.resourcemanager.elastic.models.ListAssociatedTrafficFilters;
import com.azure.resourcemanager.elastic.models.MonitorOperations;
import com.azure.resourcemanager.elastic.models.MonitoredResources;
import com.azure.resourcemanager.elastic.models.MonitoredSubscriptions;
import com.azure.resourcemanager.elastic.models.Monitors;
import com.azure.resourcemanager.elastic.models.OpenAIs;
import com.azure.resourcemanager.elastic.models.Operations;
import com.azure.resourcemanager.elastic.models.Organizations;
import com.azure.resourcemanager.elastic.models.TagRules;
import com.azure.resourcemanager.elastic.models.TrafficFilters;
import com.azure.resourcemanager.elastic.models.UpgradableVersions;
import com.azure.resourcemanager.elastic.models.VMCollections;
import com.azure.resourcemanager.elastic.models.VMHosts;
import com.azure.resourcemanager.elastic.models.VMIngestions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ElasticManager {
    private Operations operations;
    private Monitors monitors;
    private ElasticVersions elasticVersions;
    private MonitoredSubscriptions monitoredSubscriptions;
    private MonitoredResources monitoredResources;
    private DeploymentInfoes deploymentInfoes;
    private ExternalUsers externalUsers;
    private BillingInfoes billingInfoes;
    private ConnectedPartnerResources connectedPartnerResources;
    private OpenAIs openAIs;
    private TagRules tagRules;
    private VMHosts vMHosts;
    private VMIngestions vMIngestions;
    private VMCollections vMCollections;
    private UpgradableVersions upgradableVersions;
    private MonitorOperations monitorOperations;
    private AllTrafficFilters allTrafficFilters;
    private ListAssociatedTrafficFilters listAssociatedTrafficFilters;
    private CreateAndAssociateIpFilters createAndAssociateIpFilters;
    private CreateAndAssociatePLFilters createAndAssociatePLFilters;
    private AssociateTrafficFilters associateTrafficFilters;
    private DetachAndDeleteTrafficFilters detachAndDeleteTrafficFilters;
    private DetachTrafficFilters detachTrafficFilters;
    private TrafficFilters trafficFilters;
    private Organizations organizations;
    private final ElasticManagementClient clientObject;

    private ElasticManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new ElasticManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static ElasticManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return ElasticManager.configure().authenticate(credential, profile);
    }

    public static ElasticManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new ElasticManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public Monitors monitors() {
        if (this.monitors == null) {
            this.monitors = new MonitorsImpl(this.clientObject.getMonitors(), this);
        }
        return this.monitors;
    }

    public ElasticVersions elasticVersions() {
        if (this.elasticVersions == null) {
            this.elasticVersions = new ElasticVersionsImpl(this.clientObject.getElasticVersions(), this);
        }
        return this.elasticVersions;
    }

    public MonitoredSubscriptions monitoredSubscriptions() {
        if (this.monitoredSubscriptions == null) {
            this.monitoredSubscriptions = new MonitoredSubscriptionsImpl(this.clientObject.getMonitoredSubscriptions(), this);
        }
        return this.monitoredSubscriptions;
    }

    public MonitoredResources monitoredResources() {
        if (this.monitoredResources == null) {
            this.monitoredResources = new MonitoredResourcesImpl(this.clientObject.getMonitoredResources(), this);
        }
        return this.monitoredResources;
    }

    public DeploymentInfoes deploymentInfoes() {
        if (this.deploymentInfoes == null) {
            this.deploymentInfoes = new DeploymentInfoesImpl(this.clientObject.getDeploymentInfoes(), this);
        }
        return this.deploymentInfoes;
    }

    public ExternalUsers externalUsers() {
        if (this.externalUsers == null) {
            this.externalUsers = new ExternalUsersImpl(this.clientObject.getExternalUsers(), this);
        }
        return this.externalUsers;
    }

    public BillingInfoes billingInfoes() {
        if (this.billingInfoes == null) {
            this.billingInfoes = new BillingInfoesImpl(this.clientObject.getBillingInfoes(), this);
        }
        return this.billingInfoes;
    }

    public ConnectedPartnerResources connectedPartnerResources() {
        if (this.connectedPartnerResources == null) {
            this.connectedPartnerResources = new ConnectedPartnerResourcesImpl(this.clientObject.getConnectedPartnerResources(), this);
        }
        return this.connectedPartnerResources;
    }

    public OpenAIs openAIs() {
        if (this.openAIs == null) {
            this.openAIs = new OpenAIsImpl(this.clientObject.getOpenAIs(), this);
        }
        return this.openAIs;
    }

    public TagRules tagRules() {
        if (this.tagRules == null) {
            this.tagRules = new TagRulesImpl(this.clientObject.getTagRules(), this);
        }
        return this.tagRules;
    }

    public VMHosts vMHosts() {
        if (this.vMHosts == null) {
            this.vMHosts = new VMHostsImpl(this.clientObject.getVMHosts(), this);
        }
        return this.vMHosts;
    }

    public VMIngestions vMIngestions() {
        if (this.vMIngestions == null) {
            this.vMIngestions = new VMIngestionsImpl(this.clientObject.getVMIngestions(), this);
        }
        return this.vMIngestions;
    }

    public VMCollections vMCollections() {
        if (this.vMCollections == null) {
            this.vMCollections = new VMCollectionsImpl(this.clientObject.getVMCollections(), this);
        }
        return this.vMCollections;
    }

    public UpgradableVersions upgradableVersions() {
        if (this.upgradableVersions == null) {
            this.upgradableVersions = new UpgradableVersionsImpl(this.clientObject.getUpgradableVersions(), this);
        }
        return this.upgradableVersions;
    }

    public MonitorOperations monitorOperations() {
        if (this.monitorOperations == null) {
            this.monitorOperations = new MonitorOperationsImpl(this.clientObject.getMonitorOperations(), this);
        }
        return this.monitorOperations;
    }

    public AllTrafficFilters allTrafficFilters() {
        if (this.allTrafficFilters == null) {
            this.allTrafficFilters = new AllTrafficFiltersImpl(this.clientObject.getAllTrafficFilters(), this);
        }
        return this.allTrafficFilters;
    }

    public ListAssociatedTrafficFilters listAssociatedTrafficFilters() {
        if (this.listAssociatedTrafficFilters == null) {
            this.listAssociatedTrafficFilters = new ListAssociatedTrafficFiltersImpl(this.clientObject.getListAssociatedTrafficFilters(), this);
        }
        return this.listAssociatedTrafficFilters;
    }

    public CreateAndAssociateIpFilters createAndAssociateIpFilters() {
        if (this.createAndAssociateIpFilters == null) {
            this.createAndAssociateIpFilters = new CreateAndAssociateIpFiltersImpl(this.clientObject.getCreateAndAssociateIpFilters(), this);
        }
        return this.createAndAssociateIpFilters;
    }

    public CreateAndAssociatePLFilters createAndAssociatePLFilters() {
        if (this.createAndAssociatePLFilters == null) {
            this.createAndAssociatePLFilters = new CreateAndAssociatePLFiltersImpl(this.clientObject.getCreateAndAssociatePLFilters(), this);
        }
        return this.createAndAssociatePLFilters;
    }

    public AssociateTrafficFilters associateTrafficFilters() {
        if (this.associateTrafficFilters == null) {
            this.associateTrafficFilters = new AssociateTrafficFiltersImpl(this.clientObject.getAssociateTrafficFilters(), this);
        }
        return this.associateTrafficFilters;
    }

    public DetachAndDeleteTrafficFilters detachAndDeleteTrafficFilters() {
        if (this.detachAndDeleteTrafficFilters == null) {
            this.detachAndDeleteTrafficFilters = new DetachAndDeleteTrafficFiltersImpl(this.clientObject.getDetachAndDeleteTrafficFilters(), this);
        }
        return this.detachAndDeleteTrafficFilters;
    }

    public DetachTrafficFilters detachTrafficFilters() {
        if (this.detachTrafficFilters == null) {
            this.detachTrafficFilters = new DetachTrafficFiltersImpl(this.clientObject.getDetachTrafficFilters(), this);
        }
        return this.detachTrafficFilters;
    }

    public TrafficFilters trafficFilters() {
        if (this.trafficFilters == null) {
            this.trafficFilters = new TrafficFiltersImpl(this.clientObject.getTrafficFilters(), this);
        }
        return this.trafficFilters;
    }

    public Organizations organizations() {
        if (this.organizations == null) {
            this.organizations = new OrganizationsImpl(this.clientObject.getOrganizations(), this);
        }
        return this.organizations;
    }

    public ElasticManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-elastic.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public ElasticManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.elastic").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new ElasticManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

