/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.durabletask.models.RedundancyState;
import com.azure.resourcemanager.durabletask.models.SchedulerSkuName;
import java.io.IOException;

public final class SchedulerSkuUpdate
implements JsonSerializable<SchedulerSkuUpdate> {
    private SchedulerSkuName name;
    private Integer capacity;
    private RedundancyState redundancyState;

    public SchedulerSkuName name() {
        return this.name;
    }

    public SchedulerSkuUpdate withName(SchedulerSkuName name) {
        this.name = name;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public SchedulerSkuUpdate withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public RedundancyState redundancyState() {
        return this.redundancyState;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", (Number)this.capacity);
        return jsonWriter.writeEndObject();
    }

    public static SchedulerSkuUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (SchedulerSkuUpdate)jsonReader.readObject(reader -> {
            SchedulerSkuUpdate deserializedSchedulerSkuUpdate = new SchedulerSkuUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSchedulerSkuUpdate.name = SchedulerSkuName.fromString(reader.getString());
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedSchedulerSkuUpdate.capacity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("redundancyState".equals(fieldName)) {
                    deserializedSchedulerSkuUpdate.redundancyState = RedundancyState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchedulerSkuUpdate;
        });
    }
}

