/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.durabletask.fluent.TaskHubsClient;
import com.azure.resourcemanager.durabletask.fluent.models.TaskHubInner;
import com.azure.resourcemanager.durabletask.implementation.DurableTaskManagementClientImpl;
import com.azure.resourcemanager.durabletask.implementation.models.TaskHubListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TaskHubsClientImpl
implements TaskHubsClient {
    private final TaskHubsService service;
    private final DurableTaskManagementClientImpl client;

    TaskHubsClientImpl(DurableTaskManagementClientImpl client) {
        this.service = (TaskHubsService)RestProxy.create(TaskHubsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<TaskHubInner>> getWithResponseAsync(String resourceGroupName, String schedulerName, String taskHubName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TaskHubInner> getAsync(String resourceGroupName, String schedulerName, String taskHubName) {
        return this.getWithResponseAsync(resourceGroupName, schedulerName, taskHubName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((TaskHubInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TaskHubInner> getWithResponse(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskHubInner get(String resourceGroupName, String schedulerName, String taskHubName) {
        return (TaskHubInner)((Object)this.getWithResponse(resourceGroupName, schedulerName, taskHubName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource, Context context) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<TaskHubInner>, TaskHubInner> beginCreateOrUpdateAsync(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, schedulerName, taskHubName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)TaskHubInner.class), (Type)((Object)TaskHubInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskHubInner>, TaskHubInner> beginCreateOrUpdate(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, schedulerName, taskHubName, resource);
        return this.client.getLroResult(response, (Type)((Object)TaskHubInner.class), (Type)((Object)TaskHubInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<TaskHubInner>, TaskHubInner> beginCreateOrUpdate(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, schedulerName, taskHubName, resource, context);
        return this.client.getLroResult(response, (Type)((Object)TaskHubInner.class), (Type)((Object)TaskHubInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<TaskHubInner> createOrUpdateAsync(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, schedulerName, taskHubName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskHubInner createOrUpdate(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource) {
        return (TaskHubInner)((Object)this.beginCreateOrUpdate(resourceGroupName, schedulerName, taskHubName, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public TaskHubInner createOrUpdate(String resourceGroupName, String schedulerName, String taskHubName, TaskHubInner resource, Context context) {
        return (TaskHubInner)((Object)this.beginCreateOrUpdate(resourceGroupName, schedulerName, taskHubName, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String schedulerName, String taskHubName) {
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String schedulerName, String taskHubName) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, taskHubName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String schedulerName, String taskHubName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, schedulerName, taskHubName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String schedulerName, String taskHubName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, schedulerName, taskHubName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, schedulerName, taskHubName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String schedulerName, String taskHubName) {
        return this.beginDeleteAsync(resourceGroupName, schedulerName, taskHubName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String schedulerName, String taskHubName) {
        this.beginDelete(resourceGroupName, schedulerName, taskHubName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String schedulerName, String taskHubName, Context context) {
        this.beginDelete(resourceGroupName, schedulerName, taskHubName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskHubInner>> listBySchedulerSinglePageAsync(String resourceGroupName, String schedulerName) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByScheduler(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TaskHubInner> listBySchedulerAsync(String resourceGroupName, String schedulerName) {
        return new PagedFlux(() -> this.listBySchedulerSinglePageAsync(resourceGroupName, schedulerName), nextLink -> this.listBySchedulerNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TaskHubInner> listBySchedulerSinglePage(String resourceGroupName, String schedulerName) {
        String accept = "application/json";
        Response<TaskHubListResult> res = this.service.listBySchedulerSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TaskHubInner> listBySchedulerSinglePage(String resourceGroupName, String schedulerName, Context context) {
        String accept = "application/json";
        Response<TaskHubListResult> res = this.service.listBySchedulerSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, schedulerName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaskHubInner> listByScheduler(String resourceGroupName, String schedulerName) {
        return new PagedIterable(() -> this.listBySchedulerSinglePage(resourceGroupName, schedulerName), nextLink -> this.listBySchedulerNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TaskHubInner> listByScheduler(String resourceGroupName, String schedulerName, Context context) {
        return new PagedIterable(() -> this.listBySchedulerSinglePage(resourceGroupName, schedulerName, context), nextLink -> this.listBySchedulerNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TaskHubInner>> listBySchedulerNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySchedulerNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TaskHubInner> listBySchedulerNextSinglePage(String nextLink) {
        String accept = "application/json";
        Response<TaskHubListResult> res = this.service.listBySchedulerNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<TaskHubInner> listBySchedulerNextSinglePage(String nextLink, Context context) {
        String accept = "application/json";
        Response<TaskHubListResult> res = this.service.listBySchedulerNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TaskHubListResult)res.getValue()).value(), ((TaskHubListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DurableTaskManagementClientTaskHubs")
    public static interface TaskHubsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskHubInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TaskHubInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") TaskHubInner var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, @HeaderParam(value="Content-Type") String var7, @HeaderParam(value="Accept") String var8, @BodyParam(value="application/json") TaskHubInner var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, Context var7);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs/{taskHubName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @PathParam(value="taskHubName") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskHubListResult>> listByScheduler(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DurableTask/schedulers/{schedulerName}/taskHubs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TaskHubListResult> listBySchedulerSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="schedulerName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TaskHubListResult>> listBySchedulerNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<TaskHubListResult> listBySchedulerNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

