/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.durabletask.fluent.models.TaskHubInner;
import java.io.IOException;
import java.util.List;

public final class TaskHubListResult
implements JsonSerializable<TaskHubListResult> {
    private List<TaskHubInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(TaskHubListResult.class);

    private TaskHubListResult() {
    }

    public List<TaskHubInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model TaskHubListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static TaskHubListResult fromJson(JsonReader jsonReader) throws IOException {
        return (TaskHubListResult)jsonReader.readObject(reader -> {
            TaskHubListResult deserializedTaskHubListResult = new TaskHubListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTaskHubListResult.value = value = reader.readArray(reader1 -> TaskHubInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedTaskHubListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskHubListResult;
        });
    }
}

