/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.durabletask.DurableTaskManager;
import com.azure.resourcemanager.durabletask.fluent.RetentionPoliciesClient;
import com.azure.resourcemanager.durabletask.fluent.models.RetentionPolicyInner;
import com.azure.resourcemanager.durabletask.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.durabletask.implementation.RetentionPolicyImpl;
import com.azure.resourcemanager.durabletask.models.RetentionPolicies;
import com.azure.resourcemanager.durabletask.models.RetentionPolicy;

public final class RetentionPoliciesImpl
implements RetentionPolicies {
    private static final ClientLogger LOGGER = new ClientLogger(RetentionPoliciesImpl.class);
    private final RetentionPoliciesClient innerClient;
    private final DurableTaskManager serviceManager;

    public RetentionPoliciesImpl(RetentionPoliciesClient innerClient, DurableTaskManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<RetentionPolicy> getWithResponse(String resourceGroupName, String schedulerName, Context context) {
        Response<RetentionPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, schedulerName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RetentionPolicyImpl((RetentionPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public RetentionPolicy get(String resourceGroupName, String schedulerName) {
        RetentionPolicyInner inner = this.serviceClient().get(resourceGroupName, schedulerName);
        if (inner != null) {
            return new RetentionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RetentionPolicy createOrReplace(String resourceGroupName, String schedulerName, RetentionPolicyInner resource) {
        RetentionPolicyInner inner = this.serviceClient().createOrReplace(resourceGroupName, schedulerName, resource);
        if (inner != null) {
            return new RetentionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RetentionPolicy createOrReplace(String resourceGroupName, String schedulerName, RetentionPolicyInner resource, Context context) {
        RetentionPolicyInner inner = this.serviceClient().createOrReplace(resourceGroupName, schedulerName, resource, context);
        if (inner != null) {
            return new RetentionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RetentionPolicy update(String resourceGroupName, String schedulerName, RetentionPolicyInner properties) {
        RetentionPolicyInner inner = this.serviceClient().update(resourceGroupName, schedulerName, properties);
        if (inner != null) {
            return new RetentionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public RetentionPolicy update(String resourceGroupName, String schedulerName, RetentionPolicyInner properties, Context context) {
        RetentionPolicyInner inner = this.serviceClient().update(resourceGroupName, schedulerName, properties, context);
        if (inner != null) {
            return new RetentionPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String schedulerName) {
        this.serviceClient().delete(resourceGroupName, schedulerName);
    }

    @Override
    public void delete(String resourceGroupName, String schedulerName, Context context) {
        this.serviceClient().delete(resourceGroupName, schedulerName, context);
    }

    @Override
    public PagedIterable<RetentionPolicy> listByScheduler(String resourceGroupName, String schedulerName) {
        PagedIterable<RetentionPolicyInner> inner = this.serviceClient().listByScheduler(resourceGroupName, schedulerName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RetentionPolicyImpl((RetentionPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<RetentionPolicy> listByScheduler(String resourceGroupName, String schedulerName, Context context) {
        PagedIterable<RetentionPolicyInner> inner = this.serviceClient().listByScheduler(resourceGroupName, schedulerName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new RetentionPolicyImpl((RetentionPolicyInner)((Object)inner1), this.manager()));
    }

    private RetentionPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private DurableTaskManager manager() {
        return this.serviceManager;
    }
}

