/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.durabletask.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.durabletask.models.ProvisioningState;
import com.azure.resourcemanager.durabletask.models.SchedulerSku;
import java.io.IOException;
import java.util.List;

public final class SchedulerProperties
implements JsonSerializable<SchedulerProperties> {
    private ProvisioningState provisioningState;
    private String endpoint;
    private List<String> ipAllowlist;
    private SchedulerSku sku;
    private static final ClientLogger LOGGER = new ClientLogger(SchedulerProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public List<String> ipAllowlist() {
        return this.ipAllowlist;
    }

    public SchedulerProperties withIpAllowlist(List<String> ipAllowlist) {
        this.ipAllowlist = ipAllowlist;
        return this;
    }

    public SchedulerSku sku() {
        return this.sku;
    }

    public SchedulerProperties withSku(SchedulerSku sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
        if (this.ipAllowlist() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAllowlist in model SchedulerProperties"));
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model SchedulerProperties"));
        }
        this.sku().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipAllowlist", this.ipAllowlist, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static SchedulerProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SchedulerProperties)jsonReader.readObject(reader -> {
            SchedulerProperties deserializedSchedulerProperties = new SchedulerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipAllowlist".equals(fieldName)) {
                    List ipAllowlist;
                    deserializedSchedulerProperties.ipAllowlist = ipAllowlist = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSchedulerProperties.sku = SchedulerSku.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSchedulerProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedSchedulerProperties.endpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchedulerProperties;
        });
    }
}

