/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dnsresolver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dnsresolver.fluent.models.ForwardingRulePatchProperties;
import com.azure.resourcemanager.dnsresolver.models.ForwardingRuleState;
import com.azure.resourcemanager.dnsresolver.models.TargetDnsServer;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ForwardingRulePatch
implements JsonSerializable<ForwardingRulePatch> {
    private ForwardingRulePatchProperties innerProperties;

    private ForwardingRulePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public List<TargetDnsServer> targetDnsServers() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDnsServers();
    }

    public ForwardingRulePatch withTargetDnsServers(List<TargetDnsServer> targetDnsServers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRulePatchProperties();
        }
        this.innerProperties().withTargetDnsServers(targetDnsServers);
        return this;
    }

    public Map<String, String> metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public ForwardingRulePatch withMetadata(Map<String, String> metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRulePatchProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public ForwardingRuleState forwardingRuleState() {
        return this.innerProperties() == null ? null : this.innerProperties().forwardingRuleState();
    }

    public ForwardingRulePatch withForwardingRuleState(ForwardingRuleState forwardingRuleState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ForwardingRulePatchProperties();
        }
        this.innerProperties().withForwardingRuleState(forwardingRuleState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ForwardingRulePatch fromJson(JsonReader jsonReader) throws IOException {
        return (ForwardingRulePatch)jsonReader.readObject(reader -> {
            ForwardingRulePatch deserializedForwardingRulePatch = new ForwardingRulePatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedForwardingRulePatch.innerProperties = ForwardingRulePatchProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedForwardingRulePatch;
        });
    }
}

